#include "WakeupLight.h"

typedef enum
{
    LUS_CLOCK,
    LUS_CLOCK_IN_WORDS,
    LUS_SLIDESHOW,

} LAST_USED_SCREENSAVER_ENUM;
    
int32_t                         timeOut;
LAST_USED_SCREENSAVER_ENUM      lastUsedScreensaver=LUS_CLOCK;

void UI_MainHandler(UI_REASON_ENUM reason,int32_t index,UI_STRUCT *ui)
{
    switch (reason)
    {
        case UR_CLICK:
            timeOut=RTC_Get(NULL);                  // actually, this is only needed for LED_... because these will not issue UR_SHOW
            if (index==0)
            {
                lastUsedScreensaver=LUS_CLOCK;
                UI_Show(&uiClock);
            }
            else if (index==1)
            {
                lastUsedScreensaver=LUS_CLOCK_IN_WORDS;
                UI_Show(&uiClockInWords);
            }
            else if (index==2)
            {
                lastUsedScreensaver=LUS_SLIDESHOW;
                UI_Show(&uiSlideshow);
            }
            else if (index==3)
                UI_WakeupShow();
            else if (index==4)
                UI_TimeShow();
            else if (index==5)
                LED_StartAnimation(LAE_WAKEUP);
            else if (index==6)
                LED_StartAnimation(LAE_OFF);
            else if (index==7)
                UI_Show(&uiColorTest);
            break;

        case UR_TIMER:
            if ((RTC_Get(NULL)-timeOut)>10)
            {
                switch (lastUsedScreensaver)
                {
                    case LUS_CLOCK:                 UI_Show(&uiClock);          break;
                    case LUS_CLOCK_IN_WORDS:        UI_Show(&uiClockInWords);   break;
                    case LUS_SLIDESHOW:             UI_Show(&uiSlideshow);      break;
                }
            }
            break;
            
        case UR_SHOW:
            timeOut=RTC_Get(NULL);
            break;
    }
}
