#ifndef __Interface_h
#define __Interface_h

#pragma pack(1)

#define BUFFER_SIZE             1000            // number of samples per HT_DATA report

#define CHANNEL_COUNT           2
#define HEADER_MAGIC            0x53636F70      // 'Scop'

typedef enum
{
    HT_NONE,
    HT_DATA,
    HT_INFO_REQUEST,
    HT_INFO_RESPONSE,
    HT_CAPTURE_START,

} HEADER_TYPE_ENUM;

typedef struct
{
    float                       values[CHANNEL_COUNT];

} VALUES_STRUCT;

typedef struct
{
    uint32_t                    magic;
    uint8_t                     type;
    uint32_t                    length;                     // length in bytes of following data

} HEADER_STRUCT;

typedef struct
{
    uint8_t                     versionMajor;
    uint8_t                     versionMinor;
    char                        name[20];

} INTERFACE_INFO_RESPONSE_STRUCT;

typedef enum
{
    TM_NONE                     =0x00,
    TM_RAISING                  =0x01,
    TM_FALLING                  =0x02,
    TM_AUTO                     =0x04,
    
} TRIGGER_MODE_ENUM;

typedef struct
{
    float                       triggerLevel;
    uint8_t                     triggerMode;
    uint16_t                    delay;                      // in usec

} INTERFACE_CAPTURE_START_STRUCT;

#pragma pack()

#endif
