#include "mbed.h"

#define DEBUG

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
Serial probe(p9,p10);

#ifdef DEBUG
Serial pc(USBTX,USBRX);
#endif

char serialBuffer[256];
unsigned char serialBufferLoc = 0;

void rxInterrupt(void){
    led2=!led2;
    serialBuffer[serialBufferLoc] = LPC_UART3->RBR; //read the input
    //serialBuffer[serialBufferLoc] = probe.getc(); //stops the controller
    
    LPC_UART0->RBR = serialBuffer[serialBufferLoc]; //write to the pc
    //pc.putc(serialBuffer[serialBufferLoc]); //stops the controller
    
    if (serialBuffer[serialBufferLoc] == 0x0A) {
        led3 =! led3;
    }

    serialBufferLoc++;
}

void serialProbeInit(void){
    probe.baud(9600);
    probe.format(8,Serial::None,1);
    probe.attach(&rxInterrupt,Serial::RxIrq);
}

#ifdef DEBUG
void serialPcInit(void){
    pc.baud(115200);
    pc.format(8,Serial::None,1);
}
#endif

int main(){
    serialProbeInit();
#ifdef DEBUG
    serialPcInit();
    pc.printf("Comtest, MBED started\r\n");
#endif    
    while(1){
        led1 = 1;
        wait(0.2);
        led1 = 0;
        wait(0.2);
    }
}
