#include "mbed.h"
#include "stdint.h"
#include <VL6180x.h>
#define VL6180X_ADDRESS 0x29
VL6180xIdentification identification;
Serial pc(PC_10,PC_11);
// mbed uses 8bit addresses shift address by 1 bit left
VL6180x sensor(A4, A5, VL6180X_ADDRESS<<1);//距离传感器

AnalogIn switch1(PA_0); //光敏传感器

I2C i2c(I2C_SDA, I2C_SCL); //颜色传感器
int sensor_addr = 41 << 1;
DigitalOut green(LED1);

void ret_rgb(int r,int g,int b) //该函数用于返回颜色值
 {
 
 if (r > g*1.3 && r > b*1.3)
 {
 pc.printf("red\n");
 }
 else if (g > r*1.3 && g > b*1.3)
 {
 pc.printf("green\n");
 }
 else if (b > r*1.3 && b > g*1.3) 
 {
 pc.printf("blue\n");
 }
 else
 pc.printf("no\n");
 wait(0.1);
 }
void bgr()
{
    //打开颜色传感器
    int r,g,b;
    green = 1; // off
    pc.baud(115200);
    // Connect to the Color sensor and verify whether we connected to the correct sensor. 
    
    i2c.frequency(100000);
    
    char id_regval[1] = {146};
    char data[1] = {0};
    i2c.write(sensor_addr,id_regval,1, true);
    i2c.read(sensor_addr,data,1,false);
    
    if (data[0]==68) {
        green = 0;
        wait (2); 
        green = 1;
        } else {
        green = 1; 
    }
    
    // Initialize color sensor
    
    char timing_register[2] = {129,0};
    i2c.write(sensor_addr,timing_register,2,false);
    
    char control_register[2] = {143,0};
    i2c.write(sensor_addr,control_register,2,false);
    
    char enable_register[2] = {128,3};
    i2c.write(sensor_addr,enable_register,2,false);
    
    // Read data from color sensor (Clear/Red/Green/Blue)
    
    
        char clear_reg[1] = {148};
        char clear_data[2] = {0,0};
        i2c.write(sensor_addr,clear_reg,1, true);
        i2c.read(sensor_addr,clear_data,2, false);
        
        int clear_value = ((int)clear_data[1] << 8) | clear_data[0];
        
        char red_reg[1] = {150};
        char red_data[2] = {0,0};
        i2c.write(sensor_addr,red_reg,1, true);
        i2c.read(sensor_addr,red_data,2, false);
        
        int red_value = ((int)red_data[1] << 8) | red_data[0];
        
        char green_reg[1] = {152};
        char green_data[2] = {0,0};
        i2c.write(sensor_addr,green_reg,1, true);
        i2c.read(sensor_addr,green_data,2, false);
        
        int green_value = ((int)green_data[1] << 8) | green_data[0];
        
        char blue_reg[1] = {154};
        char blue_data[2] = {0,0};
        i2c.write(sensor_addr,blue_reg,1, true);
        i2c.read(sensor_addr,blue_data,2, false);
        
        int blue_value = ((int)blue_data[1] << 8) | blue_data[0];
        
        // print sensor readings
        
        //pc.printf("Clear (%d), Red (%d), Green (%d), Blue (%d)\n", clear_value, red_value, green_value, blue_value);
        wait(0.5);
    
         //颜色传感器显示数据
         r = red_value;
         g = green_value;
         b = blue_value;
         pc.printf("R %d G %d B %d\n ",r,g,b);
         ret_rgb(r,g,b);
    
    }

 
 void color_read()
 {
  //打开颜色传感器
    int r,g,b;
    green = 1; // off
    pc.baud(115200);
    // Connect to the Color sensor and verify whether we connected to the correct sensor. 
    
    i2c.frequency(100000);
    
    char id_regval[1] = {146};
    char data[1] = {0};
    i2c.write(sensor_addr,id_regval,1, true);
    i2c.read(sensor_addr,data,1,false);
    
    if (data[0]==68) {
        green = 0;
        wait (2); 
        green = 1;
        } else {
        green = 1; 
    }
    
    // Initialize color sensor
    
    char timing_register[2] = {129,0};
    i2c.write(sensor_addr,timing_register,2,false);
    
    char control_register[2] = {143,0};
    i2c.write(sensor_addr,control_register,2,false);
    
    char enable_register[2] = {128,3};
    i2c.write(sensor_addr,enable_register,2,false);
    
    // Read data from color sensor (Clear/Red/Green/Blue)
    
    while (true) { 
        char clear_reg[1] = {148};
        char clear_data[2] = {0,0};
        i2c.write(sensor_addr,clear_reg,1, true);
        i2c.read(sensor_addr,clear_data,2, false);
        
        int clear_value = ((int)clear_data[1] << 8) | clear_data[0];
        
        char red_reg[1] = {150};
        char red_data[2] = {0,0};
        i2c.write(sensor_addr,red_reg,1, true);
        i2c.read(sensor_addr,red_data,2, false);
        
        int red_value = ((int)red_data[1] << 8) | red_data[0];
        
        char green_reg[1] = {152};
        char green_data[2] = {0,0};
        i2c.write(sensor_addr,green_reg,1, true);
        i2c.read(sensor_addr,green_data,2, false);
        
        int green_value = ((int)green_data[1] << 8) | green_data[0];
        
        char blue_reg[1] = {154};
        char blue_data[2] = {0,0};
        i2c.write(sensor_addr,blue_reg,1, true);
        i2c.read(sensor_addr,blue_data,2, false);
        
        int blue_value = ((int)blue_data[1] << 8) | blue_data[0];
        
        // print sensor readings
        
        //pc.printf("Clear (%d), Red (%d), Green (%d), Blue (%d)\n", clear_value, red_value, green_value, blue_value);
        wait(0.5);
    
         //颜色传感器显示数据
         r = red_value;
         g = green_value;
         b = blue_value;
         pc.printf("R %d G %d B %d\n ",r,g,b);
         ret_rgb(r,g,b);
   }   
     }

void light_read(){
    float s1; 
    pc.baud(115200);   
    while(1) 
    {
        
        s1 = switch1.read(); 
        s1 = s1*5000;       
        pc.printf("measure = %.0f\n",s1);        
        wait(0.3);
            
    }
    }
    
void distance_read(){
  uint8_t retaddr;
  pc.baud(115200);
  wait_ms(100); // delay .1s
  sensor.getIdentification(&identification); // Retrieve manufacture info from device memory
    if(sensor.VL6180xInit() != 0) {
        printf("FAILED TO INITALIZE\n"); //Initialize device and check for errors
    };

    sensor.VL6180xDefautSettings(); //Load default settings to get started.

    wait(1);
    retaddr=sensor.changeAddress(0x29,0x27);
    sensor.getIdentification(&identification); // Retrieve manufacture info from device memory

    wait(1);
    retaddr=sensor.changeAddress(0x27,0x29);
    sensor.getIdentification(&identification); // Retrieve manufacture info from device memory

    while(1) {

 
  //Get Distance and report in mm
      printf("Distance measured (mm) = ");
      printf("%d\n", sensor.getDistance() ); 
 
      wait_ms(500); 
 
    }
    
    }

int main(){
char order = pc.getc();
    printf("welcome to the matainance system :\n");
    switch(order){
        case 'a'://颜色传感器
        color_read();
        break;
        
        case 'b'://距离传感器
        distance_read();
        break;
        
        case 'c'://光敏传感器
        light_read();
        break;
        
        case 'd'://led闪烁
        for(int p=0;p<10;p++){
            green = ~green;
            }
        break;
        
        case 'e':
        pc.printf("00\n");
        break;
        
        case 'f':
        pc.printf("01\n");    
        break;
        
        case 'g':
        pc.printf("10\n");
        break;
        
        case 'h':
        pc.printf("11\n");    
        break;
        
        }
}
