#include "mbed.h"
#include "timesync.h"

//#define ECHO

DigitalOut myled(LED2);
DigitalOut mypin(p21);

Serial command(p9,p10);

timeval_t t;

void pinToggle()
{
    mypin = !mypin;
    myled = !myled;
}

int main() {
    enum {
        IDLE=0, 
        HOST_INPUT
    } state;
    uint8_t c = 0;
    uint32_t data = 0;

    state  = IDLE;
    timesync_init();
    
    while(1) {
        timeval_t t;
        switch(state) {
            case IDLE:
                c = command.getc();
#ifdef ECHO
                command.putc(c);
#endif
                if (c == 'S') {
                    data = 0;
                    state = HOST_INPUT;
                }
                break;
            case HOST_INPUT:
                c = command.getc();
#ifdef ECHO
                command.putc(c);
#endif
                if (c >= '0' && c <= '9') {
                    data = data * 10 + c-'0';
                } else if (c == 'E') {
#ifdef ECHO
                    command.putc('\r');
                    command.putc('\n');
#endif
                    t.tv_sec = data / 1000000;
                    t.tv_usec = data % 1000000;
                    runAtTime(&pinToggle, &t);
                    state = IDLE;
                }
                break;
        }
    }
}
