#ifndef TIMESYNC_H
#define TIMESYNC_H

#include "mbed.h"

typedef unsigned int uint32_t;
typedef int int32_t;
typedef unsigned short uint16_t;
typedef short int16_t;
typedef unsigned char uint8_t;
//typedef char int8_t;

typedef struct timeval {
    int32_t tv_sec;
    uint32_t tv_usec;
} timeval_t;

typedef struct hdtimeval {
    int32_t tv_sec;
    uint32_t ticks;
} hdtimeval_t;

typedef union sync_pkt24 {
    struct {
        uint32_t rx_time;
        uint16_t tx_time;
    };
    struct {
        char no_use;
        char raw[5];
    };
} sync_pkt24_t;

typedef union sync_pkt32 {
    struct {
        uint32_t rx_time;
        uint16_t tx_time;
    };
    char raw[6];
} sync_pkt32_t;

typedef union sync_pkt64 {
    struct {
        hdtimeval_t rx_time;
        uint16_t tx_time;
    };
    char raw[10];
} sync_pkt64_t;

typedef enum {
    SYNCTYPE_NONE = 0,
    SYNCTYPE_64 = 0xA0,
    SYNCTYPE_32 = 0xA3,
    SYNCTYPE_24 = 0xA5
} synctype_t;

void timesync_init();

void getTime(struct timeval * tv);
int runAtTime(void (*schedFunc)(void), struct timeval *tv);
void runAtTrigger(void (*trigFunc)(struct timeval *tv));

#define TMR LPC_TIM2
#define MAX_TICK (SystemCoreClock)

#define PCLK_DEVIDER 1  // PCLK = CCLK
#define CLK_TIMER 12     // TIMER2 as the timer
#define CLK_UART 16     // UART2 as uart
#define PCTIM0 1        // Power Control Timer0
#define PCTIM1 2        // Power Control Timer1
#define PCTIM2 22        // Power Control Timer1
#define PCUART2 24      // Power Control UART2

#define QUEUE_SIZE 16

#endif //TIMESYNC_H
