#include "mbed.h"
#include "timesync.h"

extern uint32_t sync_count[3];

DigitalOut myled(LED2);
DigitalOut mypin(p21);
timeval_t tblink, tblink1, ttoggle;

void pinToggle()
{
    getTime(&tblink1);
    mypin = !mypin;
    myled = !myled;
}

void reportToggle(struct timeval * t)
{
    int32_t diff;
    diff = (tblink1.tv_sec - t->tv_sec)*1000000+tblink1.tv_usec - t->tv_usec;
    //diff = t->tv_sec * 1000000 + t->tv_usec;
    //printf("triggered: %d.%06d ", t->tv_sec, t->tv_usec);
    //printf("expect: %d.%06d\r\n", texpect.tv_sec, texpect.tv_usec);
    printf("%d,%d,%d,%d\r\n", diff, sync_count[0],sync_count[1],sync_count[2]);
}

int main() {
    timesync_init();
    
    tblink.tv_sec = 5;
    tblink.tv_usec = 500000;
    runAtTrigger(&reportToggle);
    while(1)
    {
        if (runAtTime(&pinToggle, &tblink)==0) {
            tblink.tv_sec ++;
        }
        wait_ms(20);
    }    
}
