#include "mbed.h"
#include "timesync.h"

DigitalOut myled(LED2);
DigitalOut mypin(p21);

Serial forwarding(p9,p10);
Serial command(USBTX,USBRX);

void pinToggle()
{
    mypin = !mypin;
    myled = !myled;
}

void reportToggle(struct timeval * t)
{
    uint32_t diff;
    diff = t->tv_sec * 1000000 + t->tv_usec;
    command.printf("%u\r\n", diff);
}

void forward1()
{
    command.putc(forwarding.getc());
}

int main() {
    enum {
        IDLE=0, 
        HOST_INPUT
    } state;
    uint8_t c = 0;
    uint32_t data = 0;

    state  = IDLE;
    timesync_init();
    
    forwarding.attach(&forward1, Serial::RxIrq);
    runAtTrigger(&reportToggle);
    while(1)
    {
        timeval_t t;
        switch(state) {
            case IDLE:
                forwarding.putc(c = command.getc());
                if (c == 'S') {
                    data = 0;
                    state = HOST_INPUT;
                }
                break;
            case HOST_INPUT:
                forwarding.putc(c = command.getc());
                if (c >= '0' && c <= '9') {
                    data = data * 10 + c-'0';
                } else if (c == 'E') {
                    t.tv_sec = data / 1000000;
                    t.tv_usec = data % 1000000;
                    runAtTime(&pinToggle, &t);
                    state = IDLE;
                }
                break;
        }
    }    
}
