#include "mbed.h"
#include "wave_player.h"
#include "PinDetect.h"
#include "USBHostMSD.h"
#include "C12832.h"
#include <vector>
#include <string>

//Set up LEDs
DigitalOut led1( LED1 );
DigitalOut led2( LED2 );
DigitalOut led3( LED3 );
DigitalOut led4( LED4 );

//Setup RGB led
PwmOut r (p23); //RGB LED pins
PwmOut g (p24);
PwmOut b (p25);

using namespace std;

C12832 lcd(p5, p7, p6, p8, p11);

//Joystick controller
PinDetect pb1(p13);//joyleft
PinDetect pb2(p16);//joyright
PinDetect pb3(p12); //joyup
PinDetect pb4(p15); //joydown
PinDetect pb5(p14);//center

AnalogOut DACout(p18); //set up speaker
wave_player waver(&DACout); //set up wave player library
int pos = 0; // index of the song
int vol = 0; // volume controller
 
bool playing = false; //variable for pause/play 
bool firstplay = false; //variable for first play
vector<string> filenames; //filenames are stored in a vector string

void read_file_names(char *dir) // function that reads in file names from sd cards
{
    DIR *dp;
    struct dirent *dirp;
    dp = opendir(dir);
    //read all directory and file names in current directory into filename vector
    while((dirp = readdir(dp)) != NULL) {
        filenames.push_back(string(dirp->d_name));
    }
}

//interrupt handler for pb1 
void pb1_hit_callback (void)
{ 
    int l = filenames.size();
    if (pos < (l-1)) {
        pos++;
    } else if (pos == (l-1)) {
        pos = 0;
    }
    led1 = 1;
    led2 = 0;
    led3 = 0;
    led4 = 0;
}
//interrupt handler for pb2
void pb2_hit_callback (void)
{
    int l = filenames.size();
    if (pos > 0) {
        pos--;
    } else if (pos == 0 ) {
        pos = l-1;
    }
    led1 = 0;
    led2 = 1;
    led3 = 0;
    led4 = 0;
}

//interrupt handler for pb3
void pb3_hit_callback (void){
    vol = (vol+1) % 16;
    led1 = 0;
    led2 = 0;
    led3 = 1;
    led4 = 0;
}

//interrupt handler for pb4 
void pb4_hit_callback (void){
    if (vol > 1) {
        vol = (vol-1) % 16;
    }
    led1 = 0;
    led2 = 0;
    led3 = 0;
    led4 = 1;
}

//interrupt handler for 3rd pushbutton
void pb5_hit_callback (void)
{
    //this interrupt handler changes the play to pause mode or vice versa
    if (playing == false && firstplay == false) {
        playing = true; 
        firstplay = true;
        r = 1;
    } else if (playing == true) {
        string songname = filenames[pos];
        playing = false;
        firstplay = false;
        g = 1;
    }
}


int main()
{
    //test LCD display
    lcd.cls();
    lcd.locate(0,3);
    lcd.printf("MBED Music Player");

    pb1.mode(PullDown);
    pb2.mode(PullDown);
    pb3.mode(PullDown);
    pb4.mode(PullDown);
    pb5.mode(PullDown);

    wait(.01);
    // Setup Interrupt callback functions for a pb hit
    pb1.attach_deasserted(&pb1_hit_callback);
    pb2.attach_deasserted(&pb2_hit_callback);
    pb3.attach_deasserted(&pb3_hit_callback);
    pb4.attach_deasserted(&pb4_hit_callback);
    pb5.attach_deasserted(&pb5_hit_callback);
    // Start sampling pb inputs using interrupts
    pb1.setSampleFrequency();
    pb2.setSampleFrequency();
    pb3.setSampleFrequency();
    pb4.setSampleFrequency();
    pb5.setSampleFrequency();

    lcd.cls();
    USBHostMSD msc("msc");
    // Check if a USB is connected
    while(!msc.connect()) {
        lcd.locate(0,0);
        lcd.printf("Insert USB");
        wait(.5);
    }    
    // Read the songs array, please note that your wav files have to be stored in the same directory
    read_file_names("/msc/music_wav");
    
    while(1) {    
        lcd.cls();
        lcd.locate(0,2);
        lcd.printf("Press joystick to play");
        //while pb3 is low, press fire button to start playing a song
        while(playing == true && firstplay == false) { 
            string songname = filenames[pos];
            string a = "/msc/music_wav/";
            string fname = a + songname; //retrieves the file name
            FILE *wave_file; 
            lcd.cls();
            lcd.locate(0,1);
            lcd.printf("Playing: %s",fname.c_str());
            wave_file = fopen(fname.c_str(),"r"); //opens the music file
            waver.play(wave_file);
            fclose(wave_file);
        }
        firstplay = false;
        // if device disconnected, try to connect again
        if (!msc.connected())
            break;
    }
}

