#include "mbed.h"

#include "MSCFileSystem.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
#include <wave_player.h>

// Network and USB filesystem
EthernetNetIf eth;
HTTPClient http;
MSCFileSystem usb("usb");
LocalFileSystem local("local");

// Audio Output
AnalogOut DACout(p18);
wave_player audio(&DACout);
 
DigitalOut myled(LED1);

// Simple HTTP helper functions
int get_file(char *url, char *file) {
    printf("Getting url to file [%s]...\n", url);
    HTTPFile f(file);
    HTTPResult r = http.get(url, &f);
    if (r != HTTP_OK) {
        printf("HTTPResult error %d\n", r);
        
        return 0;
    }
    return 1;
}

int get_string(char *url, char *str) {
    printf("Getting url [%s] to string...\n", url);
    HTTPText t;
    HTTPResult r = http.get(url, &t);
    if (r != HTTP_OK) {
        printf("HTTPResult error %d\n", r);
        str[0] = 0;
        return 0;
    }
    strcpy(str, t.gets());
    return 1;
}

FILE *wave_file;
void PlayWav(char *filename)
{
  wave_file=fopen(filename, "r");
  audio.play(wave_file);
  fclose(wave_file);
}




char receiveBuffer[100];
char randomNumber[5];
const char* genURL = "http://www.yourdomain.com/voice.php?msg=";
char urlBuffer[70];
char nameBuffer[20];
FILE *fp;

int main() {
    printf("Setup network...\n");
    EthernetErr ethErr = eth.setup();
    if(ethErr) {
        printf("Error %d in setup\n", ethErr);
    } 
    
    /* Just make sure USB is initialized */
    DIR *d;
    struct dirent *p;
    d = opendir("/usb");
    printf("\nList of files on the flash drive:\n");
    if ( d != NULL )
    {
        while ( (p = readdir(d)) != NULL )
        {
            printf(" - %s\n", p->d_name);
        }
    }
    else
    {
        error("Could not open directory!\n");
    }    
    printf("\n\n");
    

    printf("Getting overall-message\n");
    get_string("http://www.yourdomain.com/voice.php?msg=The+random+number+is", receiveBuffer);
    strcat(receiveBuffer, "\n");
    printf(receiveBuffer);
    
    get_file("http://www.yourdomain.com/voice.wav", "/usb/random.wav");  
        
        
    printf("\nStarting Random-Number Generator cycle\n\n");    
    while(1) {
        if (get_string("http://www.yourdomain.com/rand.php", receiveBuffer) == 0)
            continue;
        strcpy(randomNumber, receiveBuffer);
        
        strcpy(receiveBuffer, "The random number is ");
        strcat(receiveBuffer, randomNumber);
        strcat(receiveBuffer, "\n\n");
        printf(receiveBuffer); // Print the random number
              
        myled = 1;
    
        strcpy(nameBuffer, "/usb/number");
        strcat(nameBuffer, randomNumber);
        strcat(nameBuffer, ".wav");
        
        /* Check if the file exists already */
        fp = fopen(nameBuffer, "r");
        if ( fp == NULL )
        {          
            /* If not, download the number */
            strcpy(urlBuffer, genURL);
            strcat(urlBuffer, randomNumber);
            
            get_string(urlBuffer, receiveBuffer);
            strcat(receiveBuffer, "\n\n");
            printf(receiveBuffer);
        
            get_file("www.yourdomain.com/voice.wav", nameBuffer);      
        } else {
            fclose(fp);
        }
                                
        PlayWav("/usb/random.wav");
        PlayWav(nameBuffer);
           
        
        myled = 0;        
    }
}


#if 0
#include "mbed.h"
#include "MSCFileSystem.h"
//#include <stat.h>

#define FSNAME "msc"
MSCFileSystem msc(FSNAME);

int main()
{
	DIR *d;
	struct dirent *p;
	//struct stat st;
	//char path[PATH_MAX];
    
    printf("\n\n================================\n");
    printf("USB Mass storage demo program for mbed LPC1768\n");
    printf("================================\n\n");
    
	d = opendir("/" FSNAME);
    
    printf("\nList of files on the flash drive:\n");
    if ( d != NULL )
    {
        while ( (p = readdir(d)) != NULL )
        {
        	printf(" - %s\n", p->d_name);
        	/* no <stat.h> on mbed, it seems :/
        	sprintf(path, "/"FSNAME"/%s", p->d_name);
        	if ( stat(path, &st) == 0 )
        	{
        	  if ( S_ISDIR(st.st_mode) )
        	    printf(" <directory>\n");
        	  else
        	    printf(" %d\n", st.st_size);
        	}
        	else
        	{
        	  printf(" ???\n");
        	}*/
        }
    }
    else
    {
    	error("Could not open directory!");
    }
    printf("\nTesting file write:\n");
    FILE *fp = fopen( "/" FSNAME "/msctest.txt", "w");
    if ( fp == NULL )
    {
        error("Could not open file for write\n");
    }
    fprintf(fp, "Hello mass storage!");
    fclose(fp); 
    printf("\n - OK\n");

    printf("\nTesting file read:\n");
    fp = fopen( "/" FSNAME "/msctest.txt", "r");
    if ( fp == NULL )
    {
        error("Could not open file for read\n");
    }
    char buf[256];
    if ( NULL == fgets(buf, sizeof(buf), fp) )
    {
        error("Error reading from file\n");
    }
    fclose(fp); 
    printf("\n - OK, read string: '%s'\n\n", buf);
}
#endif