#include "mbed.h"
#include "TextLCD.h"

DigitalOut myled(LED1);
DigitalIn UP (p11);
DigitalIn DOWN (p12);
DigitalIn ENTER (p13);
DigitalIn BACK (p14);
//DigitalIn B3 (p15);
//DigitalIn C3 (p16);
PwmOut pwm1 (p23);
PwmOut pwm2 (p22);
PwmOut pwm3 (p21);

TextLCD lcd(p5, p6, p7, p8, p9, p10, TextLCD::LCD20x4); // RS, E, D4-D7
 
DigitalIn sensor (p17);
DigitalIn sensor2 (p18);

Timer temporizador;
Timer temporizador2;

#define GAIN 5.0

 int US=0, US2=0,result=0, result2=0, ajusteM3=0, contador=0;
 float  tolup, toldown, processValue=0, old_rpm=0,erro=0,output,setPoint=0;
 float  tolup2, toldown2, processValue2=0, old_rpm2=0,erro2=0,output2,setPoint2=0;

int main() {
    
    int lastUP=0, lastDOWN=0, lastENTER=0, lastBACK=0; //ultimo B
    
    lcd.locate(2, 0);
    lcd.printf("MAHM COMPONENTES");
    lcd.locate(0, 1);
    lcd.printf("Dosador 1:      RPM");
    lcd.locate(0, 2);
    lcd.printf("Dosador 2:         ");
    lcd.locate(0, 3);
    lcd.printf("Espalhador:        ");
    

   
    pwm1.period_us(10000); 
    pwm1.pulsewidth_us(10000);
    pwm2.period_us(10000);
    pwm2.pulsewidth_us(10000); 
    pwm3.period_us(10000); 
    pwm3.pulsewidth_us(10000);
    
    result=0;
    processValue=0;
    old_rpm=0;
    US=sensor;
 
    result2=0;
    processValue2=0;
    old_rpm2=0;
    US2=sensor2;
    
    while(1)
    {   
    
        if ((ENTER==1) && (lastENTER==0))
        {
            contador++;
            if(contador >= 4) contador=1;
        }
        lastENTER = ENTER;
            
        if ((BACK==1) && (lastBACK==0))
        {
            contador--;
            if(contador <= 0) contador=3;
        }        
      lastBACK = BACK;
       
       if (contador == 1)
       { 
           /*Set Point dos Motores 1 e 2*/       
             if ((UP==1) && (lastUP==0))
           {
               if(setPoint<50) setPoint++;
           }
         lastUP=UP;

             if ((DOWN==1) && (lastDOWN==0))
           {
                 if(setPoint>0) setPoint--;
           }
         lastDOWN=DOWN;     
             
       }
       
        lcd.locate(11, 1);
        lcd.printf("%2.1f  ", setPoint);  
          
        if (contador == 2)
       {        
             if ((UP==1) && (lastUP==0))
           {
                if(setPoint2<50) setPoint2++;
           }
         lastUP=UP;
      
             if ((DOWN==1) && (lastDOWN==0))
           {
                if(setPoint2>0) setPoint2--;
           }     
         lastDOWN=DOWN; 
        }
        
        lcd.locate(11, 2);
        lcd.printf("%2.1f  ", setPoint2);
        
        
           if (contador == 3)
       {          
           /*Ajuste de 0 a 100% Motor 3*/
            if ((UP==1) && (lastUP==0))
          {
                if(ajusteM3<100) ajusteM3++;
                pwm3.pulsewidth_us((100-ajusteM3)*100);
          }
         lastUP=UP;
      
             if ((DOWN==1) && (lastDOWN==0))
           {
                if(ajusteM3>0) ajusteM3--;
                pwm3.pulsewidth_us((100-ajusteM3)*100);
           }
         lastDOWN=DOWN; 
      }       
        
        lcd.locate(12, 3);
        lcd.printf("%d%%  ", ajusteM3); 
        
        /*Process Value dos Motores 1 e 2*/              
        /*Motor 1*/
         if ((sensor==1) && (US==0)){ //borda de subida
                 temporizador.stop();         
                 result=temporizador.read_ms();
                 temporizador.reset();
                 temporizador.start();} 
                 
        US=sensor;
        
        if (temporizador.read_ms()>=1000){   //Verifica se o timer esta ligado
                temporizador.stop();
                temporizador.reset();
                result=0;}
         
         if (result!=0) processValue=60/(((float)result*12)/1000);    //Conversao para RPM
         else processValue=0;
        
         tolup=old_rpm+1;
         toldown=old_rpm-1;
              
      /*  lcd.locate(12, 3);
        
        if((processValue>toldown) && (processValue<tolup)){
                lcd.printf("%2.1f ",old_rpm);}
                
        else{ 
              lcd.printf("%2.1f ",processValue);
              old_rpm=processValue;}*/
        
        
        /*Motor 2*/
        if ((sensor2==1) && (US2==0)){ //borda de subida
                 temporizador2.stop();         
                 result2=temporizador2.read_ms();
                 temporizador2.reset();
                 temporizador2.start();} 
      
           US2=sensor2;
        
        if (temporizador2.read_ms()>=1000){ //Verifica se o timer esta ligado
                temporizador2.stop();
                temporizador2.reset();
                result2=0;}
         
         if (result2!=0) processValue2=60/(((float)result2*12)/1000);   //Conversao para RPM
         else processValue2=0;
     
         tolup2=old_rpm2+1;
         toldown2=old_rpm2-1;
              
        /* lcd.locate(17, 3);
        
        if((processValue2>toldown2) && (processValue2<tolup2)){
                lcd.printf("%2.1f ",old_rpm2);}
                
        else{ 
              lcd.printf("%2.1f ",processValue2);
              old_rpm2=processValue2;}*/
        
        /*Controle Proporcional Motor 1 e 2*/
        
        erro=setPoint-processValue;
        
        output+=erro*GAIN;
        if(output>10000)output=10000;
        if(output<0)output=0;
        float val = output;
        if(val < 2000)val=0;
        pwm1.pulsewidth_us(10000-val);    
        
        erro2=setPoint2-processValue2;
        
        output2+=erro2*GAIN;
        if(output2>10000)output2=10000;
        if(output2<0)output2=0;
        float val2 = output2;
        if(val2 < 2000)val2=0;
        pwm2.pulsewidth_us(10000-val2);  
    }
}
