#include "mbed.h"

#include <json/config.h>
#include <json/value.h>
#include <json/writer.h>
#include <json/config.h>
#include <json/json.h>
#include <cstring>
#include <limits>
#include <sstream>
#include <string>
#include <iomanip>
#include <stdio.h>
#include <deque>

DigitalOut led1(LED1);
Serial pc(USBTX, USBRX);

bool running;
Thread thread;

// Blink function toggles the led in a long running loop
void blink(DigitalOut *led) {
    while (running) {
        *led = !*led;
        wait(1);
    }
}

void callback_ex() {
    // Note: you need to actually read from the serial to clear the RX interrupt
    int tmp=pc.getc();
    //printf("%c\n", tmp);
}

// Spawns a thread to run blink for 5 seconds
// main() runs in its own thread in the OS
int main() {
    
    
    pc.baud(9600);
    pc.attach(&callback_ex);
    
    thread.start(callback(blink, &led1));
    
    running = true;

    
    //thread_gsensor.start(callback(gsensorThread));
    //wait(1);
    //thread_motor.start(callback(motorThread));
    //wait(1);
    //thread_sonar.start(callback(sonarThread));
    
    //Thread thread_sonar(sonarThread);
    
     Json::Reader reader;

  Json::Value json_object;

  const char* json_document = "{\"age\" : 26,\"name\" : \"huchao\"}";

  if (!reader.parse(json_document, json_object))return 0;

  printf("name : %s\n",json_object["name"]);

  printf("name : %s\n",json_object["age"]);
}


/*
主程序指定中断函数
flipper.attach(&flip, 2.0); // the address of the function to be attached (flip) and the interval (2 seconds)

主程序指定 类 的 方法
t.attach(callback(&f, &Flipper::flip), 2.0); // the address of the object, member function, and interval


1、线程
需加载mbed-os

#include "mbed.h"

Thread thread;
DigitalOut led1(LED1);
volatile bool running = true;

// Blink function toggles the led in a long running loop
void blink(DigitalOut *led) {
    while (running) {
        *led = !*led;
        wait(1);
    }
}

// Spawns a thread to run blink for 5 seconds
int main() {
    thread.start(callback(blink, &led1));
    wait(5);
    running = false;
    thread.join();
}


2、休眠+按键中断唤醒
需更新mbed
使用F401板时，IDD电流测试，运行时:18mA，灯亮时21 .2mA，睡眠时：6.26 mA，深度睡眠时：0.68 mA，

RTC唤醒使用第三方类（未测试）

#include "mbed.h"

InterruptIn event(USER_BUTTON);
DigitalOut myled(LED1);

int go_to_sleep = 0;

void pressed()
{
    printf("Button pressed\n");
    go_to_sleep = go_to_sleep + 1;
    if (go_to_sleep > 3) go_to_sleep = 0;

}

int main()
{
    int i = 0;

    printf("\nPress Button to enter/exit sleep & deepsleep\n");

    event.fall(&pressed);

    while (1) {

        if ((go_to_sleep == 0) || (go_to_sleep == 2)) {
            printf("%d: Running\n", i);
            myled = !myled;
            wait(1.0);
        }

        if (go_to_sleep == 1) {
            myled = 0;
            printf("%d: Entering sleep (press user button to resume)\n", i);
            sleep();
        }

        if (go_to_sleep == 3) {
            myled = 0;
            printf("%d: Entering deepsleep (press user button to resume)\n", i);
            deepsleep();
        }

        i++;
    }
}


3、系统定时器中断
#include "mbed.h"

Ticker toggle_led_ticker;

DigitalOut led1(LED1);

void toggle_led() {
    led1 = !led1;
}

int main() {
    // Init the ticker with the address of the function (toggle_led) to be attached and the interval (100 ms)
    toggle_led_ticker.attach(&toggle_led, 0.1);
    while (true) {
        // Do other things...
    }
}

4、超时定时器中断
#include "mbed.h"
 
// A class for flip()-ing a DigitalOut 
class Flipper {
public:
    Flipper(PinName pin) : _pin(pin) {
        _pin = 0;
    }
    void flip() {
        _pin = !_pin;
    }
private:
    DigitalOut _pin;
};
 
DigitalOut led1(LED1);
Flipper f(LED2);
Timeout t;
 
int main() {
    // the address of the object, member function, and interval
    t.attach(callback(&f, &Flipper::flip), 2.0); 
 
    // spin in a main loop. flipper will interrupt it to call flip
    while(1) {
        led1 = !led1;
        wait(0.2);
    }
}
            

5、通用定时器中断

 // Count the time to toggle a LED
 
 #include "mbed.h"
 
 Timer timer;
 DigitalOut led(LED1);
 int begin, end;
 
 int main() {
     timer.start();
     begin = timer.read_us();
     led = !led;
     end = timer.read_us();
     printf("Toggle the led takes %d us", end - begin);
 }

6、外部中断附加事件
需加载mbed-os

#include "mbed.h"
#include "mbed_events.h"

DigitalOut led1(LED1);
InterruptIn sw(SW2);
EventQueue queue(32 * EVENTS_EVENT_SIZE);
Thread t;

void rise_handler(void) {
    // Toggle LED
    led1 = !led1;
}

void fall_handler(void) {
    printf("fall_handler in context %p\r\n", Thread::gettid());
    // Toggle LED
    led1 = !led1;
}

int main() {
    // Start the event queue
    t.start(callback(&queue, &EventQueue::dispatch_forever));
    printf("Starting in context %p\r\n", Thread::gettid());
    // The 'rise' handler will execute in IRQ context
    sw.rise(rise_handler);
    // The 'fall' handler will execute in the context of thread 't'
    sw.fall(queue.event(fall_handler));
}


7、线程间信号量的传递
需加载mbed-os

#include "mbed.h"
 
Thread thread;
DigitalOut led(LED1);
 
void led_thread() {
    while (true) {
        // Signal flags that are reported as event are automatically cleared.
        Thread::signal_wait(0x1);
        led = !led;
    }
}
 
int main (void) {
    thread.start(callback(led_thread));
 
    while (true) {
        wait(1);
        thread.signal_set(0x1);
    }
}

*/
