#ifndef I_H
#define I_H

#include "mbed.h"

/** Transfer function of an integrator.
 * G(s) = Y(s) / U(s) = K_I / s
 *
 * Author(s): TVZ Mechatronics Team
 *
 */
class I {
    public:
        /** Default constructor.
         * K_I = 1, sampleTime = 0.1
         */
        I();
        /** Integrator gain and sample time in seconds. */
        I(double K_I, double sampleTime);
        /** Update integrator gain and sample time. */
        void setParameters(double K_I, double sampleTime);
        /** Calculate the output y. */
        double out();
        /** Set the input u. */
        void in(double u);
    private:
        double K_I, T_d, y, y_p1, u, u_p1;
};

#endif // I_H