#ifndef PT2_H
#define PT2_H

#include "mbed.h"

/** Transfer function of a PT2 form.
 * G(s) = Y(s) / U(s) = K / ( (1 + T_1 s) * (1 + T_2 s) )
 *
 * Author(s): TVZ Mechatronics Team
 *
 */
class PT2 {
    public:
        /** Default constructor.
         * K = 1, T_1 = 1 s, T_2 = 0.5 s, sampleTime = 0.1 s.
         */
        PT2();
        /** PT2 transfer function parameters and sample time in seconds. */
        PT2(double K, double T_1, double T_2, double sampleTime);
        /** Update PT2 transfer function parameters and sample time. */
        void setParameters(double K, double T_1, double T_2, double sampleTime);
        /** Calculate the output y. */
        double out();
        /** Set the input u. */
        void in(double u);
    private:
        double K, T_1, T_2, T_d, a, b, c, d, a_1, a_2, b_1, b_2, y, y_p1, y_p2, u, u_p1, u_p2;
};

#endif // PT2_H