
#include "mbed.h"
#include <string>

#include "JPEGCamera.h"

#define buf_max 256

Serial pc(SERIAL_TX, SERIAL_RX); // SERIAL_TX(D1), SERIAL_RX(D0) read from bluetooth module VERIFIED
Serial sim808(PA_9, PA_10); // TX(D8), RX(D2) to camera
JPEGCamera camera(PA_11, PA_12); // TX6, RX6 to camera

//I2C_SCL--PB_8(D15)
//I2C_SDA--PB_9(D14)

DigitalIn mybutton(USER_BUTTON);//PC_13
DigitalOut myled(LED1);//PA_5(D13)
DigitalOut sim_power(D4);//PB_5  //复位SIM808

//Camera time
Timer timer;

int  rec_cnt = 0;                         //receive count
char result[buf_max];

void sim_callback()
{
    char x;
    x = sim808.getc();
    result[rec_cnt++]= x;
    pc.putc(x);
        if(rec_cnt>=buf_max-1)rec_cnt=0;
}
bool sim_wait(void)
{
        char *p; 
        int x=20;
        rec_cnt = 0;
    memset(result,0,buf_max*sizeof(char));
    while(x)
        {
            wait(1);
            p=strstr(result,"OK");
            if(p) 
            {    
        return true;
            } 
            x--;
        }
        return false;
}

void sim_gprs_updata(string s)
{
    pc.printf("%s",s);           //发送内容
    pc.putc(0x1a);//CtrlZ
      
    sim808.printf("%s",s);           //发送内容
    sim808.putc(0x1a);
      
    if(sim_wait()) {    
        pc.printf("TCP send OK\r\n");
    } else {
        pc.printf("TCP send Field\r\n");
    }
}

void sim_gprs_init(void)
{

    pc.printf("AT\r\n");
    sim808.printf("AT\r\n");
    
    if(sim_wait()) { 
        pc.printf("SIM AT OK.\r\n");//
    }
    else{   
        pc.printf("Reset SIM808.\r\n");//
        sim_power.write(0);
        wait(3);
        sim_power.write(1);
        wait(19);
    }
    
    pc.printf("ATE0\r\n");//关闭回显 
    sim808.printf("ATE0\r\n");//关闭回显 
    wait(1);
    
    pc.printf("AT+CPIN?\r\n");
    sim808.printf("AT+CPIN?\r\n");//SIM卡状态
    if(sim_wait()) {    
        pc.printf("SIM CARD CPIN OK\r\n");
    } else {
        pc.printf("SIM CARD CPIN Field\r\n");
    }
    
        pc.printf("AT+CSQ\r\n");
    sim808.printf("AT+CSQ\r\n");//信号状态
    if(sim_wait()) {    
        pc.printf("SIM CARD signal OK\r\n");
    } else {
        pc.printf("SIM CARD signal Field\r\n");
    }
        
        pc.printf("AT+CREG?\r\n");                 //判断SIM卡网络是否注册成功
    sim808.printf("AT+CREG?\r\n");             //判断SIM卡网络是否注册成功
    if(sim_wait()) {    
        pc.printf("SIM CARD REG OK\r\n");
    } else {
        pc.printf("SIM CARD REG Field\r\n");
    }
    
    pc.printf("AT+CGATT?\r\n");                  //GPRS附着状态
    sim808.printf("AT+CGATT?\r\n");              //GPRS附着状态

    if(sim_wait()) {    
        pc.printf("SIM CGATT OK\r\n");
    } else {
        pc.printf("SIM CGATT Field\r\n");
    }
   
//-----------------------组合命令------------------------------------------------------------
        
    pc.printf("AT+CSTT=\"CMNET\"\r\n");         //set APN
    sim808.printf("AT+CSTT=\"CMNET\"\r\n");         //set APN

    if(sim_wait()) {    
        pc.printf("SIM set APN OK\r\n");
    } 
        else 
        {
                pc.printf("SIM set APN Field\r\n");
                return ;
    }
    
    pc.printf("AT+CIICR\r\n");                    //wireless link 建立无线链路
    sim808.printf("AT+CIICR\r\n");                    //wireless link 建立无线链路

    if(sim_wait()) {    
        pc.printf("SIM wireless link OK\r\n");
    } else {
        pc.printf("SIM wireless link Field\r\n");
    }
        
    wait(15);//等待建立无线链路
        
        pc.printf("AT+CIFSR\r\n");                    //获取本地IP
    sim808.printf("AT+CIFSR\r\n");                    //获取本地IP
        
    pc.printf("AT+CIPSTART=\"TCP\",\"122.5.17.146\",\"9980\"\r\n");       //TCP set 建立TCP连接
    sim808.printf("AT+CIPSTART=\"TCP\",\"122.5.17.146\",\"9980\"\r\n");       //TCP set 建立TCP连接
        
    if(sim_wait()) 
        {    
        pc.printf("SIM TCP set OK\r\n");
            
                wait(10);//等待建立TCP链路
            
                pc.printf("AT+CIPSEND\r\n");               //send direction
                sim808.printf("AT+CIPSEND\r\n");               //send direction  
                
                wait(1);
                sim_gprs_updata("TPC SEND:hello,sim808 tcp test ok!");
    } else 
        {
                pc.printf("SIM TCP set Field\r\n");
    }
    
}
void sim_gprs_relink(void)
{
    pc.printf("AT+CIPCLOSE\r\n");
    sim808.printf("AT+CIPCLOSE\r\n");//关闭连接
    if(sim_wait()) 
        {    
        pc.printf("SIM TCP CLOSE OK\r\n");
    } else 
        {
        pc.printf("SIM TCP CLOSE Field\r\n");
    }
        pc.printf("AT+CIPSTART=\"TCP\",\"122.5.17.146\",\"9980\"\r\n");       //TCP set 建立TCP连接
    sim808.printf("AT+CIPSTART=\"TCP\",\"122.5.17.146\",\"9980\"\r\n");       //TCP set 建立TCP连接
        
    if(sim_wait()) 
        {    
        pc.printf("SIM TCP set OK\r\n");
            
                wait(5);//等待建立TCP链路
            
                pc.printf("AT+CIPSEND\r\n");               //send direction
                sim808.printf("AT+CIPSEND\r\n");               //send direction  
    
                wait(1);
                sim_gprs_updata("TPC SEND:hello,sim808 tcp test ok!");
    } else 
        {
                pc.printf("SIM TCP set Field\r\n");
                pc.printf("Reset SIM808.\r\n");//
        sim_power.write(0);
        wait(3);
        sim_power.write(1);
        wait(19);
                sim_gprs_init();
    }
}

int main()
{
    int message = 0;
    
    pc.baud(115200);
    sim808.baud(115200);
    sim808.attach(&sim_callback,SerialBase::RxIrq);    //serial interrupt attach
    
    sim_power.write(1);
    //Camera Initialization and picture sizing
    timer.start();
    wait(1);
    if(camera.setPictureSize(JPEGCamera::SIZE160x120))
    {
        pc.printf("camera setPictureSize ok!\r\n");
    }
    else
    {
        pc.printf("camera setPictureSize fail!\r\n");
    }
    wait(3);
    //Continuously wait for commands
    sim_gprs_init();
    while(1) 
    {
        //Check for bytes over serial from bluetooth/xbee
        if(pc.readable()) 
        {
            message=pc.getc();    
            //Take a picture (note that this takes a while to complete and will only only work for 999 pictures
            if (message==210)//0xd2
            {
                if (camera.isReady()) 
                {
                    if (camera.takePicture()) 
                    {
                        int image_size = camera.getImageSize();
                        while (camera.isProcessing()) 
                        {
                            camera.processPicture(pc);
                        }
                    }    
                    else 
                    {
                        pc.printf("camera takePicture fail!\r\n");
                    }
                } 
                else 
                {
                    pc.printf("camera isReady fail!\r\n");
                }
            }
        }
        
        if (!mybutton)
        {
//            time_t seconds = time(NULL);
//            //pc.printf("%s", ctime(&seconds));
//            char msg[100];
//            sprintf(msg,"seconds:%d", ctime(&seconds));
//            sim_gprs_updata(msg);
                    sim_gprs_relink();
        }
    }
}

