
#include "mbed.h"
#include <string>

#include "JPEGCamera.h"
#include "MPU9150.h"
#include "Quaternion.h"

#define buf_max         256

#define sys_idle        0
#define sys_gprs        1
#define sys_camera      2
#define sys_mpu9150     3
#define sys_gps         4
#define sys_ble         5

Serial pc(SERIAL_TX, SERIAL_RX); // SERIAL_TX(D1), SERIAL_RX(D0) read from bluetooth module VERIFIED
Serial sim808(PA_9, PA_10); // TX(D8), RX(D2) to camera
JPEGCamera camera(PA_11, PA_12); // TX6, RX6 to camera

MPU9150 imu(D15, D14, D7); //scl sda int
//I2C_SCL--PB_8(D15)
//I2C_SDA--PB_9(D14)

DigitalIn mybutton(USER_BUTTON);//PC_13
DigitalOut led(LED1);//PA_5(D13)
DigitalOut sim_power(D4);//PB_5  //复位SIM808

//Camera time
Timer timer;

int sys_id=0;
int  rec_cnt = 0;                         //receive count
char result[buf_max];

//mpu9150
Quaternion q1;
char buffer[200];

void sim_callback()
{
    char x;
    x = sim808.getc();
    result[rec_cnt++]= x;
    pc.putc(x);
        if(rec_cnt>=buf_max-1)rec_cnt=0;
}
bool sim_wait(int x)
{
    char *p; 
    rec_cnt = 0;
    memset(result,0,buf_max*sizeof(char));
    while(x)
    {
        wait(1);
        p=strstr(result,"OK");
        if(p) 
        {    
            return true;
        } 
         x--;
    }
    return false;
}

void sim_gprs_updata(string s)
{
    pc.printf("%s",s);           //发送内容
    pc.putc(0x1a);//CtrlZ
      
    sim808.printf("%s",s);           //发送内容
    sim808.putc(0x1a);
    
    wait(1);  
//    if(sim_wait(1)) {    
        pc.printf("TCP send OK\r\n");
//    } else {
//        pc.printf("TCP send Field\r\n");
//    }
}

void sim_gprs_init(void)
{

    pc.printf("AT\r\n");
    sim808.printf("AT\r\n");
    
    if(sim_wait(1)) { 
        pc.printf("SIM AT OK.\r\n");//
    }
    else{   
        pc.printf("Reset SIM808.\r\n");//
        sim_power.write(0);
        wait(3);
        sim_power.write(1);
        wait(19);
    }
    
    pc.printf("ATE0\r\n");//关闭回显 
    sim808.printf("ATE0\r\n");//关闭回显 
    wait(1);
    
    pc.printf("AT+CPIN?\r\n");
    sim808.printf("AT+CPIN?\r\n");//SIM卡状态
    if(sim_wait(1)) {    
        pc.printf("SIM CARD CPIN OK\r\n");
    } else {
        pc.printf("SIM CARD CPIN Field\r\n");
    }
    
        pc.printf("AT+CSQ\r\n");
    sim808.printf("AT+CSQ\r\n");//信号状态
    if(sim_wait(1)) {    
        pc.printf("SIM CARD signal OK\r\n");
    } else {
        pc.printf("SIM CARD signal Field\r\n");
    }
        
        pc.printf("AT+CREG?\r\n");                 //判断SIM卡网络是否注册成功
    sim808.printf("AT+CREG?\r\n");             //判断SIM卡网络是否注册成功
    if(sim_wait(1)) {    
        pc.printf("SIM CARD REG OK\r\n");
    } else {
        pc.printf("SIM CARD REG Field\r\n");
    }
    
    pc.printf("AT+CGATT?\r\n");                  //GPRS附着状态
    sim808.printf("AT+CGATT?\r\n");              //GPRS附着状态

    if(sim_wait(1)) {    
        pc.printf("SIM CGATT OK\r\n");
    } else {
        pc.printf("SIM CGATT Field\r\n");
    }
    pc.printf("Waiting for sim808 start ......\r\n");
    wait(15);//等待模块启动完成
//-----------------------组合命令------------------------------------------------------------
        
    pc.printf("AT+CSTT=\"CMNET\"\r\n");         //set APN
    sim808.printf("AT+CSTT=\"CMNET\"\r\n");         //set APN

    if(sim_wait(5)) {    
        pc.printf("SIM set APN OK\r\n");
    } 
        else 
        {
                pc.printf("SIM set APN Field\r\n");
                return ;
    }
    
    pc.printf("AT+CIICR\r\n");                    //wireless link 建立无线链路
    sim808.printf("AT+CIICR\r\n");                    //wireless link 建立无线链路

    if(sim_wait(5)) {    
        pc.printf("SIM wireless link OK\r\n");
    } else {
        pc.printf("SIM wireless link Field\r\n");
    }
    
    pc.printf("Waiting for sim808 wireless link finish ......\r\n");    
    wait(15);//等待建立无线链路
        
        pc.printf("AT+CIFSR\r\n");                    //获取本地IP
    sim808.printf("AT+CIFSR\r\n");                    //获取本地IP
        
    pc.printf("AT+CIPSTART=\"TCP\",\"122.5.17.146\",\"9980\"\r\n");       //TCP set 建立TCP连接
    sim808.printf("AT+CIPSTART=\"TCP\",\"122.5.17.146\",\"9980\"\r\n");       //TCP set 建立TCP连接
        
    if(sim_wait(5)) 
        {    
        pc.printf("SIM TCP set OK\r\n");
            
                pc.printf("Waiting for sim808 tcp link finish ......\r\n");  
                wait(10);//等待建立TCP链路
            
                pc.printf("AT+CIPSEND\r\n");               //send direction
                sim808.printf("AT+CIPSEND\r\n");               //send direction  
                
                wait(1);
                sim_gprs_updata("TPC SEND:hello,sim808 tcp test ok!");
    } else 
        {
                pc.printf("SIM TCP set Field\r\n");
    }
    
}
void sim_gprs_relink(void)
{
    pc.printf("AT+CIPCLOSE\r\n");
    sim808.printf("AT+CIPCLOSE\r\n");//关闭连接
    if(sim_wait(5)) 
        {    
        pc.printf("SIM TCP CLOSE OK\r\n");
    } else 
        {
        pc.printf("SIM TCP CLOSE Field\r\n");
    }
        pc.printf("AT+CIPSTART=\"TCP\",\"122.5.17.146\",\"9980\"\r\n");       //TCP set 建立TCP连接
        sim808.printf("AT+CIPSTART=\"TCP\",\"122.5.17.146\",\"9980\"\r\n");       //TCP set 建立TCP连接
        
    if(sim_wait(5)) 
    {    
            pc.printf("SIM TCP set OK\r\n");
            
                pc.printf("Waiting for sim808 tcp link finish ......\r\n");  
                wait(10);//等待建立TCP链路
            
                pc.printf("AT+CIPSEND\r\n");               //send direction
                sim808.printf("AT+CIPSEND\r\n");               //send direction  
    
                wait(1);
                sim_gprs_updata("TPC SEND:hello,sim808 tcp test ok!");
    } else 
        {
                pc.printf("SIM TCP set Field\r\n");
                pc.printf("Reset SIM808.\r\n");//
        sim_power.write(0);
        wait(3);
        sim_power.write(1);
        wait(19);
                sim_gprs_init();
    }
}

void pro_gprs(void)
{
        if (!mybutton)
        {
//            time_t seconds = time(NULL);
//            //pc.printf("%s", ctime(&seconds));
//            char msg[100];
//            sprintf(msg,"seconds:%d", ctime(&seconds));
//            sim_gprs_updata(msg);
            sim_gprs_relink();
        }  
}
void pro_camera(void)
{
    wait(0.1);
    if (!mybutton)
    {
                if (camera.isReady()) 
                {
                    if (camera.takePicture()) 
                    {
                        int image_size = camera.getImageSize();
                        while (camera.isProcessing()) 
                        {
                            camera.processPicture(pc);
                        }
                    }    
                    else 
                    {
                        pc.printf("camera takePicture fail!\r\n");
                    }
                } 
                else 
                {
                    pc.printf("camera isReady fail!\r\n");
                }
    }
}

void pro_mpu9150(void)
{
        if(imu.getFifoCount() >= 48)
        {
            imu.getFifoBuffer(buffer,  48);
            led = !led;
        }
        
        if(timer.read_ms() > 50)
        {
            timer.reset();
           
           //This is the format of the data in the fifo, 
           /* ================================================================================================ *
             | Default MotionApps v4.1 48-byte FIFO packet structure:                                           |
             |                                                                                                  |
             | [QUAT W][      ][QUAT X][      ][QUAT Y][      ][QUAT Z][      ][GYRO X][      ][GYRO Y][      ] |
             |   0   1   2   3   4   5   6   7   8   9  10  11  12  13  14  15  16  17  18  19  20  21  22  23  |
             |                                                                                                  |
             | [GYRO Z][      ][MAG X ][MAG Y ][MAG Z ][ACC X ][      ][ACC Y ][      ][ACC Z ][      ][      ] |
             |  24  25  26  27  28  29  30  31  32  33  34  35  36  37  38  39  40  41  42  43  44  45  46  47  |
             * ================================================================================================ */
             
            
            pc.printf("acc :%d, %d, %d\r\n",  (int32_t)(((int32_t)buffer[34] << 24) + ((int32_t)buffer[35] << 16) + ((int32_t)buffer[36] << 8) + (int32_t)buffer[37]), 
                                            (int32_t)(((int32_t)buffer[38] << 24) + ((int32_t)buffer[39] << 16) + ((int32_t)buffer[40] << 8) + (int32_t)buffer[41]), 
                                            (int32_t)(((int32_t)buffer[42] << 24) + ((int32_t)buffer[43] << 16) + ((int32_t)buffer[44] << 8) + (int32_t)buffer[45]));
                                                
            pc.printf("gyro:%d, %d, %d\r\n",  (int32_t)(((int32_t)buffer[16] << 24) + ((int32_t)buffer[17] << 16) + ((int32_t)buffer[18] << 8) + (int32_t)buffer[19]),
                                            (int32_t)(((int32_t)buffer[20] << 24) + ((int32_t)buffer[21] << 16) + ((int32_t)buffer[22] << 8) + (int32_t)buffer[23]),
                                            (int32_t)(((int32_t)buffer[24] << 24) + ((int32_t)buffer[25] << 16) + ((int32_t)buffer[26] << 8) + (int32_t)buffer[27]));
                                            
            pc.printf("mag :%d, %d, %d\r\n",  (int16_t)(buffer[29] << 8) + buffer[28], 
                                            (int16_t)(buffer[31] << 8) + buffer[30], 
                                            (int16_t)(buffer[33] << 8) + buffer[32]);
                                            
            pc.printf("quat:%f, %f, %f, %f\r\n", 
                (float)((((int32_t)buffer[0] << 24) + ((int32_t)buffer[1] << 16) + ((int32_t)buffer[2] << 8) + buffer[3]))* (1.0 / (1<<30)),
                (float)((((int32_t)buffer[4] << 24) + ((int32_t)buffer[5] << 16) + ((int32_t)buffer[6] << 8) + buffer[7]))* (1.0 / (1<<30)),
                (float)((((int32_t)buffer[8] << 24) + ((int32_t)buffer[9] << 16) + ((int32_t)buffer[10] << 8) + buffer[11]))* (1.0 / (1<<30)),
                (float)((((int32_t)buffer[12] << 24) + ((int32_t)buffer[13] << 16) + ((int32_t)buffer[14] << 8) + buffer[15]))* (1.0 / (1<<30)));
            
                
            //q1.decode(buffer);
            //pc.printf("%f, %f, %f, %f\r\n", q1.w, q1.v.x, q1.v.y, q1.v.z);
 
 
            //TeaPot Demo Packet for MotionFit SDK
            /*
            pc.putc('$'); //packet start
            pc.putc((char)2); //assume packet type constant
            pc.putc((char)0); //count seems unused
            for(int i = 0; i < 16; i++){ //16 bytes for 4 32bit floats
                pc.putc((char)(buffer[i]));
            }
            for(int i = 0; i < 5; i++){ //no idea, padded with 0
                pc.putc((char)0);
            }
            */
        }
}
int main()
{
    int message = 0;
    
    pc.baud(115200);
    sim808.baud(115200);
    sim808.attach(&sim_callback,SerialBase::RxIrq);    //serial interrupt attach
    
    timer.start();
    
    //Sim808 Initialization
    sim_power.write(1);    
    sim_gprs_init();
    
    //Camera Initialization and picture sizing
    if(camera.setPictureSize(JPEGCamera::SIZE160x120))pc.printf("camera setPictureSize ok!\r\n");
    else pc.printf("camera setPictureSize fail!\r\n");
    wait(3);
    
    //MPU9150 Initialization and setting
    if(imu.isReady())pc.printf("MPU9150 is ready\r\n");
    else pc.printf("MPU9150 initialisation failure\r\n");
    
    imu.initialiseDMP();
 
    imu.setFifoReset(true);    
    imu.setDMPEnabled(true);    
    
    //Continuously wait for commands
    while(1) 
    {
        //-------------------------E事件处理-----------------------------------------------
        //Check for bytes over serial from bluetooth/xbee
        if(pc.readable()) 
        {
            message=pc.getc();    
            //Take a picture (note that this takes a while to complete and will only only work for 999 pictures
            if (message==0xd1)
            {
                sys_id=sys_gprs;
                pc.printf("sys_id is gprs\r\n");
            }
            else if (message==0xd2)
            {
                sys_id=sys_camera;
                pc.printf("sys_id is camera\r\n");
            }
            else if (message==0xd3)
            {
                sys_id=sys_mpu9150;
                pc.printf("sys_id is MPU9150\r\n");
            }
        }
        //-------------------------I事件处理-----------------------------------------------
        
        //-------------------------运行线程-----------------------------------------------
        switch(sys_id)
        {
            case sys_gprs:
                pro_gprs();
                break;
            case sys_camera:
                pro_camera();
                break;       
            case sys_mpu9150:
                pro_mpu9150();
                break;
             case sys_gps:
                break;
             case sys_ble:
                break;
            default:
                break;
        }
    }
}

