#include "DT1.h"

DT1::DT1() {
    u = y = u_p1 = y_p1 = 0;
    setParameters(1, 0.5, 0.1);
}

DT1::DT1(double T_1_, double T_D_, double T_d_) {
    u = y = u_p1 = y_p1 = 0;
    setParameters(T_1_, T_D_, T_d_);
}

void DT1::setParameters(double T_1_, double T_D_, double T_d_) {
    T_1 = T_1_;
    T_D = T_D_;
    if (T_d_ > 0) // only positive sample time values allowed
        T_d = T_d_;
    else
        T_d = 0.1;
    a_1 = -exp(-T_d/T_1);
    b_0 = T_D / T_1;
    b_1 = -b_0;
}

void DT1::in(double u_) {
    u = u_;
}

double DT1::out() {
    y = -a_1*y_p1 + b_0*u + b_1*u_p1;
    y_p1 = y;
    u_p1 = u;
    return y;
}