#ifndef PT2cc_H
#define PT2cc_H

#include "mbed.h"

/** Transfer function of a general PT2 form. cc stands for conjugate-complex.
 * G(s) = Y(s) / U(s) = K w_n^2 / ( s^2 + 2 zeta w_n + w_n^2 )
 *
 * Author(s): TVZ Mechatronics Team
 *
 */
class PT2cc {
    public:
        /** Default constructor.
         * K = 1, zeta = 0.707, w_n = 1 rad/s, sampleTime = 0.1 s.
         */
        PT2cc();
        /** PT2cc transfer function parameters K, zeta, w_n and sample time in seconds. */
        PT2cc(double K, double zeta, double w_n, double sampleTime);
        /** Update PT2cc transfer function parameters and sample time. */
        void setParameters(double K, double zeta, double w_n, double sampleTime);
        /** Calculate the output y. */
        double out();
        /** Set the input u. */
        void in(double u);
    private:
        double K, zeta, w_n, T_d, a, b, c, d, e, a_1, a_2, b_1, b_2, y, y_p1, y_p2, u, u_p1, u_p2;
};

#endif // PT2cc_H