#include "PDT1.h"

PDT1::PDT1() {
    u = y = u_p1 = y_p1 = 0;
    setParameters(1, 1, 0.5, 0.1);
}

PDT1::PDT1(double K_, double T_1_, double T_D_, double T_d_) {
    u = y = u_p1 = y_p1 = 0;
    setParameters(K_, T_1_, T_D_, T_d_);
}

void PDT1::setParameters(double K_, double T_1_, double T_D_, double T_d_) {
    K = K_;
    T_1 = T_1_;
    T_D = T_D_;
    if (T_d_ > 0) // only positive sample time values allowed
        T_d = T_d_;
    else
        T_d = 0.1;
    a_1 = -exp(-T_d/T_1);
    b_0 = K * T_D / T_1;
    b_1 = K * (1 + a_1) - b_0;
}

void PDT1::in(double u_) {
    u = u_;
}

double PDT1::out() {
    y = -a_1*y_p1 + b_0*u + b_1*u_p1;
    y_p1 = y;
    u_p1 = u;
    return y;
}