#ifndef DT1_H
#define DT1_H

#include "mbed.h"

/** Transfer function of a DT1 form.
 * G(s) = Y(s) / U(s) = T_D s / (1 + T_1 s)
 *
 * Author(s): TVZ Mechatronics Team
 *
 */
class DT1 {
    public:
        /** Default constructor. 
         * T_1 = 1, T_D = 0.5, sampleTime = 0.1
         */
        DT1();
        /** DT1 transfer function parameters and sample time in seconds. */
        DT1(double T_1, double T_D, double sampleTime);
        /** Update DT1 transfer function parameters and sample time. */
        void setParameters(double T_1, double T_D, double sampleTime);
        /** Calculate the output y. */
        double out();
        /** Set the input u. */
        void in(double u);
    private:
        double y, y_p1;
        double u, u_p1;
        double T_1, T_D, T_d, a_1, b_0, b_1;
};

#endif // DT1_H