#ifndef PDT1_H
#define PDT1_H

#include "mbed.h"

/** Transfer function of a PDT1 form.
 * G(s) = Y(s) / U(s) = K * (1 + T_D s) / (1 + T_1 s)
 *
 * Author(s): TVZ Mechatronics Team
 *
 */
class PDT1 {
    public:
        /** Default constructor. 
         * K = 1, T_1 = 1, T_D = 0.5, sampleTime = 0.1
         */
        PDT1();
        /** PDT1 transfer function parameters and sample time in seconds. */
        PDT1(double K, double T_1, double T_D, double sampleTime);
        /** Update PDT1 transfer function parameters and sample time. */
        void setParameters(double K, double T_1, double T_D, double sampleTime);
        /** Calculate the output y. */
        double out();
        /** Set the input u. */
        void in(double u);
    private:
        double y, y_p1;
        double u, u_p1;
        double K, T_1, T_D, T_d, a_1, b_0, b_1;
};

#endif // PDT1_H