#include "mbed.h"
#include "TextLCD.h"
#include "Keypad.h"      

Keypad tipkovnica(D2,D3,D4,D5,D8,D9,D10,D11);                                   
TextLCD lcd(PTE20, PTE21, PTE22, PTE23, PTE29, PTE30, TextLCD::LCD16x2);   
Serial HC05(PTE0,PTE1);  
I2C eeprom(PTC9, PTC8);  
InterruptIn gumb1(D2);  
InterruptIn gumb2(D3);
Serial pc(USBTX, USBRX); 

char kod[13],            
     primljeni_kod[13]="123456789012",           
     master_key[5] ="1234",      
     data_out[6],
     check[2],   
     tempKey[5];
              
char a,b,lock;         
int i;

bool press = 0;
                   
void writeKey(int broj_znamenki, char array[]){    
    if(b == 'a' && i>= 1){
        i--;        
        lcd.locate(i,1); 
        lcd.printf(" ");
        array[i] = 0;
        wait(0.2);
}

    else if(b == 'a' || b == 'b' || b == 'c')
        return;
        
    else if(i == broj_znamenki){
        lcd.locate(i,1);
        lcd.printf(" ");
        wait(0.1);
            }       
    else{
        lcd.locate(i,1);
        lcd.printf("%c",b);
        array[i] = b;
        i++;
        wait(0.2);
}

    if( i >= broj_znamenki){
        i = broj_znamenki;
        }                                 
}

bool scanEnter(){                                   
    if(b == 'b') return 1;      
    else         return 0;
}

void UnosKod(){                                   
    a = 2;return;
}

void UnosKey(){                                   
    a = 4;
    press = 1;
    return;
}

void buttonControl(bool stanje){                   
    if(!stanje){
    gumb1.fall(NULL);gumb2.fall(NULL);}            
    else{
    gumb1.fall(&UnosKod);gumb2.fall(&UnosKey);}    
}

void caseSet(char prvi[15],char drugi[15],bool stanje,char slucaj){
    buttonControl(stanje);
    memset(kod,0,12);
    memset(tempKey,0,4);
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("%s", prvi);
    lcd.locate(0,1);
    lcd.printf("%s", drugi);
    a = slucaj;
    i = 0;
}

void getEEPROMData(){
    memset(master_key,0,4);
    eeprom.write((0x50 << 1) & 0xFE,&data_out[0],1,true);
    eeprom.read((0x50 << 1)| 0x01,master_key,4,false);
    wait_ms(10);
    
    eeprom.write((0x50 << 1) & 0xFE,&check[0],1,true);
    eeprom.read((0x50 << 1)| 0x01,&lock,1,false);
    
    if(lock){ 
         a = 4;
         HC05.putc('N');
    
    }else{     
        a = 0;
        HC05.putc('R');
    }
}

void fun(){
    char temp = HC05.getc();
        if(temp == '?'){
            if(a != 4 || press == 1)
            HC05.putc('R');
            else
            HC05.putc('N');
        }else{
            
    HC05.putc('?');
    
    for(int i = 0; i<12; i++)
    primljeni_kod[i] =HC05.getc();
    
    //pc.printf("%s\n\r",primljeni_kod);
    } 
}
   
int main(){  
                         
    int n = 0;
    data_out[0]= 0x94;
    check[0]= 0x80;                                

    HC05.baud(9600);
    HC05.attach(&fun,Serial::RxIrq); 
    eeprom.frequency(100000);
    getEEPROMData();
        
    for(int j=0; j<4; j++)     
    lcd.printf("%c",master_key[j]);
    wait(1);

    while(1) {
        switch(a) {
            default:
                tipkovnica.cetvrtiStupac();
                caseSet("     Skener","      koda",1,1);
            break;

            case 1:
            break;

            case 2:
                caseSet("Unesite kod:","",0,0);
                while(1) {
                    
                    b = tipkovnica.keyscan();
                    if(b == 'c') break;
                    writeKey(12,kod);

                    if(scanEnter() && kod[0] != '\0') {
                                               
                        if(memcmp(primljeni_kod, kod, 12) == 0) {
                            lcd.cls();
                            lcd.printf("Tocno!");
                            memset(primljeni_kod,0,12);
                            n = 0;
                            wait(2);
                        } else {
                            n++;
                            lcd.cls();
                            lcd.printf("Krivo!");
                            wait(2);
                        }
                        
                        if(n == 3){
                            n = 0;
                            check[1] = 1;
                            eeprom.write(0x50 << 1,check,2,false);
                            a = 4;
                            HC05.putc('N');
                        }
                        break;
                    }
                }
                break;

            case 3:
                caseSet("Promjeni M.key:","",0,0);              
                while(1) {
                    
                    b = tipkovnica.keyscan();                    
                    if(b == 'c') break;
                    writeKey(4,kod);

                    if(scanEnter() && kod[3] != '\0') {
                        memmove(master_key,kod,4);
                        for(int j = 0; j<4; j++) {
                            data_out[j+1] = master_key[j];
                        }
                        eeprom.write(0x50 << 1,data_out,5,false);
                        wait_ms(10);
                        break;
                    }
                }
                break;
                
                case 4:
                caseSet("Unesite M.key:","",0,4);         
                while(1) {
                    
                    b = tipkovnica.keyscan();                    
                    if(b == 'c'){
                        if(press){a = 0; press = 0; break;}
                    else
                    continue;
                    }
                    writeKey(4,tempKey);

                    if(scanEnter() && tempKey[3] != '\0') {
                        if(memcmp(master_key, tempKey, 4) == 0) {
                            if(press){a = 3; press = 0; break;}
                            check[1] = 0;
                            eeprom.write(0x50 << 1,check,2,false);
                            a =0;
                            HC05.putc('R');
                        } else {
                           if(press){a = 0; press = 0; break;}
                           a = 4;
                           }
                    break;  
                    }
                }
                break;
            }
    }
}
