#include "mbed.h"
#include "TextLCD.h"

I2C rtc(PTC9, PTC8);
BusOut status_led(D8,D9,D10);
Serial pc(USBTX, USBRX);
TextLCD lcd(PTE20, PTE21, PTE22, PTE23, PTE29, PTE30, TextLCD::LCD16x2); 
InterruptIn tipkalo(D2);
Serial HC06(PTE0,PTE1); 
Timeout povratak;
Timer vrijeme;

char data_in[7]={'\0'};
char generated_code[13]={'\0'};

int promjena=3,br;
char temp;
char simbol;
bool poslano;
bool pocetno_stanje=0;

void getData(){
    int adr = 0x51;
    char reg_address[1] = {0x04};
    rtc.write(adr << 1, &reg_address[0],1,true); 
    rtc.read((adr << 1)| 0x01 ,data_in,7,false); 
    }
    
bool generateCode(){
    int sample;
    int j = 0;
    memset( data_in, '.', 7 );
    getData();
    
    memset( generated_code, '.', 12 );   
    
    for(int i = 0; i<7; i++){
        if(i == 4) i++;      
        sample = data_in[i] >> 4 & 0x0F;    // 01011100 >> 4 -> 00000101 & 0x0F -> 
        generated_code[j]= sample + 48;
        j++;
        sample = data_in[i] & 0x0F;
        generated_code[j]= sample + 48;
        j++;
        }
        
     for(int i=0; i<12; i++){
     if(generated_code[i] < '0' || generated_code[i] > '9')
        return 1;
        }
        return 0;   
} 


void setTime(char sati,char min,char sec,char dan,char mjesec,char godina){
    
    int adr = 0x51;
    bool ponovljeni_start = true;
    
    char data[6] ={sec,min,sati,dan,mjesec,godina};
    char registri[6] ={0x04,0x05,0x06,0x07,0x09,0x0A};
    char data_out[3]={'\0'};
    
    for(int i = 0; i<6; i++){
        if(i == 5) ponovljeni_start = false;
    data_out[0] = registri[i];   
    data_out[1] = data[i];  
    rtc.write(adr << 1, data_out,2,ponovljeni_start);
    } 
}

void ispisNaLCD(){
    promjena = 1;
    }   
    
void nazad(){
    promjena = 0;
    }
    
void slanje(){
       lcd.cls();
       lcd.printf("Slanje");
       status_led = (status_led | 1);
       
       while(vrijeme.read()<5 && poslano == 0){
                    for(br = 6; br < 9; br++){
                    lcd.locate(br,0);
                    lcd.printf(".");
                    HC06.putc('1');
                    wait(0.5);
                    if(poslano){break;}
                    }
                    lcd.locate(6,0);
                    lcd.printf("   ");
                    wait(0.5);
                }
    if(poslano){
                vrijeme.stop();
                vrijeme.reset();
                lcd.cls();
                lcd.printf("Generirani kod:");
                lcd.locate(0,1);
                lcd.printf("%s",generated_code);
                poslano = 0;
                povratak.attach(&nazad,30);
                promjena = 2;
                return;
                }else{
                vrijeme.stop();
                vrijeme.reset();
                lcd.cls();
                lcd.printf("Nije se moguce");
                lcd.locate(0,1);
                lcd.printf("spojiti!");
                status_led = (status_led & ~1);
                wait(5);
                poslano = 0;
                promjena =0;
                    }
                
    }
    
void fun(){
    simbol = HC06.getc();
    pc.printf("%c", simbol);
    switch (simbol){
        
        case '?':
        status_led = 0b011;
         for(int i=0; i<12; i++)
            HC06.putc(generated_code[i]);
            poslano = 1;
             status_led= 0b010; 

        break;
        
        case 'N':
        status_led = 0b100;
        promjena = 3;
        break;
        
        case 'R':
        status_led= 0b010;
        pocetno_stanje =1;
        promjena = 0;
        break;
        

        }
    }
    
    
int main() {
    HC06.baud(9600); 
    HC06.format(8,SerialBase::None,1);                
    rtc.frequency(100000); //100kHZ
    HC06.attach(&fun, Serial::RxIrq);
    //setTime(0x16,0x03,0x30,0x12,0x02,0x21);   
    HC06.putc('?'); 
    status_led = 0b100; 
    lcd.cls();
    lcd.printf("Povezivanje");                                              
    while(1) {
        while(pocetno_stanje == 0){ 
                for(br = 11; br < 14; br++){
                    lcd.locate(br,0);
                    lcd.printf(".");
                    HC06.putc('?');
                    wait(0.5);
                    }
                    lcd.locate(11,0);
                    lcd.printf("   ");
                    wait(0.5);
                }
        switch(promjena){
            
            default:
                tipkalo.fall(&ispisNaLCD);
                wait(1);
                lcd.cls();
                lcd.printf("    Generator");
                lcd.locate(0,1);
                lcd.printf("      koda");
                promjena = 2;
            break;
            
            case 1:
                tipkalo.fall(NULL); 
                bool check = generateCode();
                if(check){
                check = 0;
                lcd.cls();
                lcd.printf("ERROR");
                wait(1);
                promjena = 0;
                break;
                }
                vrijeme.start();
                slanje();
                
            break;
            
            case 2:
            break;
            
            case 3:
                povratak.detach();
                lcd.cls();
                lcd.printf("Standby/Locked");
                promjena = 2;
            break;
            
            }
      
    }
}