#include "mbed.h"

DigitalOut myled(LED1);
AnalogOut Aout(p18);
Ticker tick1;
//Note in this case could reconstruct at known frequency using timer(ticker)
//125 us ticker gives us 8KHz reconstruction
//8 samples/period means frequency should be 1KHz
//works perfectly




unsigned short n=0;
#define pi 3.1415192
#define N 8                 //Numebr of samples in one period 
#define w_hat 2*pi/N          //Normalised radian frequency               
float sine1 [N];              //contains sine wave sample values

void output_sample(void);
void init_sine_array(void);

int main() {
    init_sine_array();
    tick1.attach_us(&output_sample,3);    //125 us is 8Khz    //limit is 3us which means ~333KHz max fs
    while(1) {     
    }
}

void output_sample(void)
{
    Aout = sine1[n];
    n=(n+1)%N;
}

void init_sine_array(void)
{
    unsigned short n = 0;
    for (n=0;n<N;n++)
    {
        sine1[n] = 0.5 + 0.5*sin(n*w_hat);   //note the 0.5 V of offset since DAC outputs voltage between 0 and 3.3V
    }
    
 }   
