#include "mbed.h"

DigitalOut myled(LED1);
AnalogOut Aout(p18);

//Note if w_hat is pi/4 this means 8 samples/period. If we measure frequency of this output signal.
//then reconstruction frequency is 8 times this.
//Could put it through a low pass filter to smooth out.
//Also check the offset.

//Sine wave reconstruction in this case is much faster(tahn test4_sine) since I calculate the sample values before hand.
//Sine wave period is 2.2*5us = 12us
//Sine wave freq = 83KHz
//Reconstruction freq is 666KHz



unsigned short n;
#define pi 3.1415192
#define N 64                  //Numebr of samples in one period 
#define w_hat 2*pi/N          //Normalised radian frequency               
float sine1 [N];              //contains sine wave sample values

void init_sine_array(void);

int main() {
    init_sine_array();
    n=0;
    while(1) {
        
            Aout = sine1[n];
            n=(n+1)%N;
    }
}

void init_sine_array(void)
{
    unsigned short n = 0;
    for (n=0;n<N;n++)
    {
        sine1[n] = 0.5 + 0.5*sin(n*w_hat);   //note the 0.5 V of offset since DAC outputs voltage between 0 and 3.3V
    }
    
 }   
