#include "mbed.h"

DigitalOut myled(LED1);

/// Send the string message in morse code on 'myled
void morse_string(char *msg);

// Timing constants for morse code generation
#define TDOT   0.2
#define TDASH  (3*TDOT)
#define TSPLIT (1*TDOT)
#define TSPACE (3*TDASH)

int main() {
    while (1) {
        morse_string("hello world");
        wait(2*TSPACE);
    }
}

/// Table with morse code bit-patterns.
/// Each symbols dot/dash sequence is stored starting at bit 0 where
/// a set bit encodes a dash and cleared bit a dot. The sequence is terminated by a set trailing bit-
unsigned char alphabet[] = {
    0x06, // .-     a
    0x11, // -...     b
    0x15, // -.-.     c
    0x09, // -..     d
    0x02, // .     e
    0x14, // ..-.     f
    0x0b, // --.     g
    0x10, // ....     h
    0x08, // ..     i
    0x1e, // .---     j
    0x0d, // -.-     k
    0x12, // .-..     l
    0x07, // --     m
    0x05, // -.     n
    0x0F, // ---     o
    0x16, // .--.     p
    0x1b, // --.-     q
    0x0a, // .-.     r
    0x08, // ...     s
    0x03, // -     t
    0x0c, // ..-     u
    0x18, // ...-     v
    0x0e, // .--     w
    0x19, // -..-     x
    0x1d, // -.--     y
    0x13, // --..     z
    0x3f, // ----- 0
    0x3e, // .---- 1
    0x3c, // ..--- 2
    0x38, // ...-- 3
    0x30, // ....- 4
    0x20, // ..... 5
    0x21, // -.... 6
    0x23, // --... 7
    0x27, // ---.. 8
    0x2f, // ----. 9
    0x73, // --..-- ,
    0x6a, // .-.-.- .
    0x00
};

/// Convert a character to a morse-code bit pattern.
unsigned char getCode(char symbol) {
    if      (symbol >= 'a' && symbol <= 'z')    return alphabet[symbol-'a'];
    else if (symbol >= '0' && symbol <= '9')    return alphabet[symbol-'0'+26];
    else if (symbol == '.')            return alphabet[37];
    else if (symbol == ',')            return alphabet[36];
    else return 0;
}

/// Pattern of current symbol being send.
unsigned char morse_pattern = 0;

/// Set the symbol to be morsed.
/// Returns bit pattern of morse code or zero if symbol not found (e.g. for a space)
int morse_setsymbol(char symbol) {
    return morse_pattern = getCode(symbol);
}

/// Generate next dot/dash to transmit
/// Returns 0 for dot, 1 for dash and -1 for finished
int morse_next() {
    int retval = (morse_pattern & 1) ? 1 : 0;
    morse_pattern >>= 1;
    if (! morse_pattern) retval = -1;
    return retval;
}

void morse_string(char *msg) {
    int x;
    for (; *msg; msg++) {
        if (!morse_setsymbol(*msg)) {
            wait(TSPACE);
            continue;
        }
        for (x=morse_next(); x != -1; x=morse_next()) {
            myled = 1;
            wait(x ? TDASH : TDOT);
            myled = 0;
            wait(TSPLIT);
        }
        wait(TDASH);
    }
}
