#include "mbed.h"
#include "rtos.h"
#include "SDFileSystem.h"

#define FILE_LOC "/sd/test.txt"

Serial pc(USBTX, USBRX);
Serial gps(p28, p27);
Serial test(p9,p10);
SDFileSystem sd(p5, p6, p7, p8, "sd");
DigitalOut myled(LED1);
DigitalOut sdled(LED2);

void sd_thread(void const *argument) {
        while(1){
            sdled = !sdled;
            FILE *fp = NULL;
            fp = fopen(FILE_LOC, "w");
            if( fp != NULL ) fclose(fp);
            Thread::wait(1000);
        }     
}

int main() { 

    Thread sdTask(sd_thread, NULL, osPriorityNormal, DEFAULT_STACK_SIZE * 2.25);
    while(1) {
        myled = !myled;   
        Thread::wait(1000); 
    }
}
