#include <RotaryEncoder.h>

RotaryEncoder::RotaryEncoder(PinName A, PinName B)
 : terminalA(A, PullUp), terminalB(B, PullUp) 
{
}

void RotaryEncoder::attach(void (*callback)(int)) {
    callbackFunc = callback;
    tick.attach_us(this, &RotaryEncoder::smpling, RotaryEncoder_SamplingInterval);
}

void RotaryEncoder::detach() {
    tick.detach();
}

void RotaryEncoder::smpling() {
    static uint8_t val  = 0xFF;
    uint8_t now = (terminalA.read() << 1) | (terminalB.read());
    if (now == (val & 0x03)) return;
    val = (val << 2) | now;
    switch (val) {
        case 0x4B: (*callbackFunc)(1); break; // cw  : 0b01001011 = 0x4B
        case 0x87: (*callbackFunc)(0); break; // ccw : 0b10000111 = 0x87
    }
}
