#include "mbed.h"
#include <vector>

//  serial
Serial serial(D5,D4);
//  joystick analogin
AnalogIn joyX(A0);
AnalogIn joyY(A1);

int main()
{
    serial.baud(115200);
    
    while(1) {
        uint16_t x = joyX.read_u16();
        uint16_t y = joyY.read_u16();
        //  convert float to byte array
        
        char bytes[4];
        bytes[0] = x >> 8;
        bytes[1] = x & 0xfff0;
        bytes[2] = y >> 8;
        bytes[3] = y & 0xfff0;
        if(serial.writeable()) {
            //  send bytes
            serial.putc(0x3A);
            for(int i = 0; i <= 3;i++){
                serial.putc(bytes[i]);
            }
        }

        wait_ms(50);
        printf("uint[x:%d y:%d]\n\r",x,y);
    }
}
