/* ###########################################################################
**    Archivo        : main.c
**    Proyecto       : STM32-103C8_Adivina_Examen
**    Procesador     : STM32F103C8
**    Herramienta    : Mbed
**    Version        : Driver 01.01
**    Compilador     : GNU C Compiler
**    Fecha/Hora     : 14-07-2015, 11:48, # CodeGen: 0
**    Descripción    :
**         Este proyecto muestra la configuración y uso de la Terminal Serial
**         This module contains user's application code.
**   Componentes     : Timer, etc .
**   Configuraciones : Se puede seleccionar entre diferentes velocodades de 
**                     transmisión
**   Autores         :
**         ATEAM Development Group:
**          - Antulio Morgado Valle
**          - Héctor Rodríguez Altamirano
**
**   Versión        : Beta
**   Revisión       : A
**   Release        : 0
**   Bugs & Fixes   :
**   Date           : 20/10/2019
**                    Programa adivina Modificado para examen
**                    27/09/2010 
**                    
**
** ###########################################################################*/
/*
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
:  Includes
::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::::
*/

#include "stm32f103c8t6.h"
#include "mbed.h"
#include "Serial.h"
#include "stdio.h"
#include "iostream" //Para usar cout
//#include "stdlib.h"
/*
:...............................................................................
:  Definiciones
:...............................................................................
*/
#define on              0               // Estado para boton presionado
#define off             1               // Estado para boton sin presionar
#define hold            2               // Estado para boton mantenido
#define release         3               // Estado para boton liberado
#define FALSE           0               // Estado FALSO
#define TRUE            1               // Estado VERDADERO
/*
+-------------------------------------------------------------------------------
|  Configuración de Puertos 
+-------------------------------------------------------------------------------
*/
DigitalOut verde (LED1);    // PC_13    (Green_Led)
DigitalOut rojo  (PB_1);    // NC       (Red_Led)

// *****    Host PC Terminal Communication channels
Serial      terminal (PA_2, PA_3);          // Inicializa la comunicación serial a la PC (Tx,Rx)
//Serial      terminal(USBTX, USBRX,115200);// Tx, Rx  Baud Rate - Terminal Serial por USB @ 115,200 Bauds

/*
+-------------------------------------------------------------------------------
|  Variables Globales de Usuario 
+-------------------------------------------------------------------------------
*/
//uint32_t Baud_Rate = 9600;                // Velocidad de Transmisión (Bauds)
/*
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
|  Definición de Funciones Prototipo y Rutinas de los Vectores de Interrupción
++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*/
void Setup(void);  
void portada(void);
/* END definitions */ 

/*
#===============================================================================
|
|               P R O G R A M A     P R I N C I P A L
|
#=============================================================================== 
*/
int main()          
{                   // Inicialización de variables, puertos e interrupciones
confSysClock();     // Configure system clock (72MHz HSE clock, 48MHz USB clock)
Setup();            // Inicialización del sistema
    portada();
    terminal.printf ("ADIVINA\n\r");
    rojo  = off;
    verde = off;
    int intentos=0;
    char secreto;
    while(TRUE) 
    {
Inicio:     /*******************************************************************
               do{
               terminal.printf(" DIGITE UN NUMERO SECRETO DE 0 A 9 \r\n");
               secreto = terminal.getc();
               rojo = on;
               verde = on;          
               }while(secreto < '0' || secreto > '9');
               Codigo de la version anterioe en la cual el numero secreto era
               introducido por el usuario
               ****************************************************************/
            secreto=rand()%10+48; //Genera un numero aleatorio
            terminal.printf("SE GENERO UN NUMERO SECRETO ALEATORIO \r\n");
 Intenta:   intentos++;
            terminal.printf(" INTENTO NUMERO %d \r\n",intentos);
            terminal.printf(" ADIVINA EL NUMERO: \r\n");
            char respuesta = terminal.getc();
            terminal.printf(" Tu respuesta es: %c \r\n",respuesta);
            if( secreto < respuesta  ) 
            {
                terminal.printf(" Es mas Bajo  \r\n");
                rojo = on;
                verde = off;               
                goto Intenta;
            }
            if( secreto > respuesta  ) 
            {
                terminal.printf(" Es mas Alto  \r\n");
                rojo  = off;
                verde = on;
                goto Intenta;
            }
            if( secreto == respuesta ) 
            {
                intentos=0;
                terminal.printf(" CORRECTO!, Es igual a: %c \r\n",secreto);
                rojo  = off;
                verde = on;
                wait(1.0);
                rojo  = off;
                verde = off;
                wait(1.0);
                rojo  = off;
                verde = on;
                wait(1.0);
                terminal.printf(" Eres un Genio !!!  \r\n");
                wait(1.0);
                rojo  = on;
                verde = off;
                wait(1.0);
                rojo  = off;
                verde = on;
            }
        terminal.printf(" Quieres intentarlo de nuevo?  \r\n");
        terminal.printf(" 0 = No \r\n 1 = Si  \r\n");
            char opcion = terminal.getc();
            if( opcion == '1' ) goto Inicio;
            else if( opcion == '0' )
            {
                terminal.printf(" Eso es todo Amigos!  \r\n");
                break;
            }
        }
}

/* END main */

/*
................................................................................
:  Rutinas de los Vectores de Interrupción
................................................................................
*/
 
/* END Events */ 
/*
________________________________________________________________________________
|
|  Funciones Prototipo
|_______________________________________________________________________________
*/
                // Las Funciones Prototipo van aquí !
void Setup()
{
//  terminal.baud(Baud_Rate);         // Se configura la velocidad de transmisión e inicia la comunicación serial.    
  terminal.baud(115200);         // Se configura la velocidad de transmisión e inicia la comunicación serial.  
  terminal.printf(" System is Wake Up!.\n\r");
}              

void portada(void) // Implementacion de la portada
{
    //cout necesita la biblioteca "iostream"
    cout << "\t\t\t\t\t\tISTITUTO POLITECNICO NACIONAL\n\n\n";
    cout << "\t\t\t\t ESCUELA SUPERIOR DE INGENIERIA MECNICA Y "
         << "ELECTRICA\n\n\n";
    cout << "\t\t\t\t\tEXAMEN DE ANALISIS NUMERICO\n\n\n";
    cout << "\t\t\t\t\tPROFESOR: MORGADO VALLE ANTULIO\n\n\n";
    cout << "\t\t\t\t\tALUMNO: RODRIGUEZ ALTAMIRANO HECTOR"
         << "\n\n\n\n\n" << endl;
}
/* END routines */   
 
/* END program */                

/* END documentation */ 
/*
+--------------------------------------------------------------------------------
|                               EJERCICIO
|
| 1.-   Este programa tambien acepta letras o caracteres?
| 2.-   Modificar este programa para: 
|       a) Que solo acepte números
|       b) Agregar un contador de Número de Intentos 
|       
+--------------------------------------------------------------------------------
|
|                               EXAMEN
|
| 1.-   Modificar el programa para que despliegue el número de intentos para 
|       adivinar el número secreto.
| 2.-   Modificar el programa para haga eco con la respuesta que le introducimos.
|
| 3.-   Modificar el programa para que el número secreto sea generado aleatoriamente.
|       a) Generar un Número Pseudo Aleatorio Mediante el Ticker
|       b) Utilizando la función RANDOMIZE
| Suerte!
+--------------------------------------------------------------------------------
|
|                     T H E     A N T U L I U S   T E A M
|  Research, Development, Systems Equipment, Support & Spare Parts    I n c.
|                (C) Copyright 1989-2014, All rigths Reserved
|
| This program is licensed under rules of
| THE BEANERS TECHNOLOGIES PROYECT
+-------------------------------------------------------------------------------
*/
/* END Mbed */ 