#include "mbed.h"
#include "7SegSRDriver.h"
#include "TextLCD.h" //driver 1602 lcd screen

#define pin_debug 0
#if pin_debug
DigitalOut pin8(P2_7),pin6(P1_24);
Ticker pinFlip;
#endif

Timeout CalcRate;
DigitalOut led1(P2_2);
DigitalIn signal(P2_9),XFC(P2_8);;
//InterruptIn flip(P1_21),flip1(P1_23);    in mbed P1_21 is defined to be LED1, connect LCD to 3V3, can't generate interrupt
//InterruptIn flip(P2_8),flip1(P2_9); //flip XFC flip1 signal
TextLCD lcd(P0_24, P0_25, P0_26, P0_3, P0_2,P1_0,TextLCD::LCD16x2); // rs, e, d4-d7
int signalTotal,XFCTotal,sync_Pass,sync_Fail;
int i,max; //used for dataToArry function
int printArray[4];
float dataToarray(float data);
int sync_delay = 16;// sync delay micro seconds.
void pinflip();
//7 segment class definition,Data,Clock,latch
SSegSRDriver display(P2_1,P0_7,P0_9, SSegSRDriver_COMN_CATHODE);


void calcRate() {
    float rate = 0;
    int tempsignalTotal,temp_pass,temp_fail;
    int j =0;
    int LEDArray[4];
#if pin_debug
    pinFlip.detach();
#endif
    //put to temp value to ensure these values not change after this.
    tempsignalTotal =signalTotal;
    temp_pass = sync_Pass;
    temp_fail = sync_Fail;
    if(sync_Pass>0)
        rate = (float)temp_pass/(float)(temp_pass+temp_fail)*100;
    else
        rate = 0;
    i=max=0;
       lcd.cls();
    if (rate>50) {
        for (j= 0; j<=3; j++) //clear printArray buffer to 0
            printArray[j] = 0;
        dataToarray(rate);
        //lcd.printf("XFC: %6dHz\n",tempXFCTotal*2); //print XFC: 023000Hz,remeber I'm using one counter to trigger the count
        lcd.printf("Working\n"); //Don't show XFC message.
        lcd.printf("Sig: %6dHz\n",tempsignalTotal);//print Sig: 023000Hz
        j = max; //max is from dataToarray, global variable to index the lenth of the array
        //printf("The array to print is:");
        for (int a=0; a<=4; a++)
            display.clear();
        
        while (j<3) {
            //printf("%d",0);
            j++;
            for (int tempIndex = j; tempIndex>=1; tempIndex--)
                printArray[tempIndex]=printArray[tempIndex-1];
            printArray[0] = 0;
        }
        for (j=0; (j<=3); j++) {
            //printf("%d ",printArray[j]);
            LEDArray[j]=printArray[j];
        }
        if (max>3) { //which means 100%
            display.write(LEDArray[3],false);
            display.write(LEDArray[2],true);
            display.write(LEDArray[1],false);
            display.write(LEDArray[0],false);
        } else {
            display.write(LEDArray[3],false);
            display.write(LEDArray[2],false);
            display.write(LEDArray[1],true);
            display.write(LEDArray[0],false);
        }
    }
    else{
      lcd.printf("Warning!\n"); //show warning message message.
      lcd.printf("No Sync signal\n");
    }
     signalTotal = sync_Pass=sync_Fail =0;
    CalcRate.attach(&calcRate,1.0);
    led1 = !led1;
    
#if pin_debug
    pinFlip.attach_us(&pinflip,10); //the best speed is 100k/s
#endif
}
#if pin_debug
void pinflip() {
    pin8 = !pin8;
}
#endif
float dataToarray(float data) {
    if (data>=0.1) {
        i++; //counter increase
        data = dataToarray(data/10)*10;
    }

    if (max<=i)
        //make sure max is the biggest number pointer
        max = i;
    float tempData;
    tempData = data*100;
    printArray[max-i] = (int)tempData;
    data = (tempData-printArray[max-i])/100;
    i--;
    return (data);


}
int main() {
    int tempSignal,tempXFC;
    //lcd.printf("XFC: 0Hz\n"); //initialize
    lcd.printf("Working\n"); //initialize
    lcd.printf("Sig: 0Hz\n");//The Sig: 0Hz
    //clear the led first
     for (int a=0; a<=4; a++)
            display.clear();
    signalTotal = sync_Pass=sync_Fail =0;
    tempSignal = tempXFC = 0;
    CalcRate.attach(&calcRate,1.0);
#if pin_debug
    pin8 = pin6 =0;
    pinFlip.attach_us(&pinflip,10); //the best speed is 100k/s
#endif
   
    while (1) {
        if(tempSignal!=signal)
        {
            tempSignal = signal;
            signalTotal++;
        }
        if(tempXFC!=XFC)
        {
            tempXFC = XFC;
            wait_us(sync_delay);
            if(tempSignal!=signal) //synchronized 
            {
                tempSignal = signal;
                signalTotal++;  
                sync_Pass++;
            }
            else //didn't find sync signal
                sync_Fail++;
        }
        wait_us(1);
        
        


    }

}
