#include "mbed.h"
#include "7SegSRDriver.h"

/* mbed 7-Segment Display Driver Library (via an 8bit Shift Register)
 * Copyright (c) 2011 Paul Law
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */

// Display should be hooked up to shift register as follows:
// Q0 : Decimal Point, Q1-Q7 : Segments a-g

SSegSRDriver::SSegSRDriver(PinName srData, PinName srClock, PinName srLatch, bool disp_type): _srData(srData), _srClock(srClock), _srLatch(srLatch) {
    _disp_type = disp_type;
    write_raw(0);
}

void SSegSRDriver::set_type(bool disp_type) {
    _disp_type = disp_type;
}

void SSegSRDriver::clear() {
    write_raw(0);
}

void SSegSRDriver::write(unsigned char number) {
    write(number,0);
}

void SSegSRDriver::write(unsigned char number, bool dp) {
    if (number<16) {
        // Find the definition of the number in chardefs, shift left, set dp (LSB)
        if(!_disp_type) //if Common Anode
            write_raw((SSegSRDriver_chardefs[number])<<1 | dp); //small change to fit taobao buy LEDs.
        else //if common Cathode
            write_raw((SSegSRDriver_chardefs[number]) | (dp<<0x7)); //small change to fit taobao buy LEDs.
    }
}

void SSegSRDriver::write_raw(unsigned char bValue) {

    if (!_disp_type) bValue = ~bValue;  // Reverse value for Common Anode

    if (bValue<=0xFF) {
        // Push value to shift register and latch
        _srLatch = 0;
        for (int i=7;i>=0;i--) {    // Output MSB to LSB
            _srClock = 0;
            _srData = (bValue & (1<<i));
            _srClock = 1;
        }
        _srLatch = 1;
        _srData = 0;
    }
}