#include "mbed.h"

InterruptIn motion(D2);
DigitalOut gLed(LED2);
Serial pc(USBTX, USBRX);

int motion_detected = 0;
float blinkTime = .2;

void irq_handler(void)
{
    motion_detected = 1;
}

void BlinkGreen(){
            gLed = 0;  // turn myled on
            pc.printf("LED Green \r\n");
            wait(blinkTime);
            gLed = 1;  // turn myled off
            wait(blinkTime);
}
int main(void)
{
    pc.baud(115200);
    int cnt = 0;
    gLed = 1;
    motion.rise(&irq_handler);

    while(1) {
        if(motion_detected) {
            BlinkGreen();
            cnt++;
            motion_detected = 0;
            pc.printf("Hello! I've detected %d times since reset\r\n", cnt);
        }
    }
}

