#include "mbed.h"
#include "eeprom.h"

#if defined( TARGET_NUCLEO_L476RG )
#define EEPROM_BASE    ( ( uint32_t )0x0807F800U )
#define EEPROM_END     ( ( uint32_t )DATA_EEPROM_BASE + 2048 )
#elif defined( TARGET_NUCLEO_L152RE ) || defined( TARGET_NUCLEO_L073RZ )
#define EEPROM_BASE    ( ( uint32_t )0x08080000U ) 
#define EEPROM_END     ( ( uint32_t )0x080807FFU )
#else
#error "Please define EEPROM base address and size for your board "
#endif

uint8_t EepromMcuReadBuffer( uint16_t addr, uint8_t *buffer, uint16_t size )
{
    assert_param( buffer != NULL );

    // assert_param( addr >= EEPROM_BASE );
    assert_param( buffer != NULL );
    assert_param( size < ( EEPROM_END - EEPROM_BASE ) );

    memcpy( buffer, ( uint8_t* )EEPROM_BASE, size );

    return SUCCESS;
}

uint8_t EepromMcuWriteBuffer( uint16_t addr, uint8_t *buffer, uint16_t size )
{
    int n = size / 4 + (size % 4 ? 1 : 0);
    uint32_t *flash = ( uint32_t* )buffer;

    assert_param( buffer != NULL );
    assert_param( size < ( EEPROM_END - EEPROM_BASE ) );

    HAL_FLASH_Unlock( );

    for( uint32_t i = 0; i < n; i++ )
    {
        HAL_FLASH_Program( 0x02U, EEPROM_BASE + \
                           ( 4 * i ), flash[i] );
    }

    HAL_FLASH_Lock( );

    return SUCCESS;
}
