/*
 / _____)             _              | |
( (____  _____ ____ _| |_ _____  ____| |__
 \____ \| ___ |    (_   _) ___ |/ ___)  _ \
 _____) ) ____| | | || |_| ____( (___| | | |
(______/|_____)_|_|_| \__)_____)\____)_| |_|
    (C)2015 Semtech

Description: Define events during Join, Tx & Rx
            Prepare TX packet by appending with appropriate application data

License: Revised BSD License, see LICENSE.TXT file include in the project

Maintainer: Uttam Bhat
*/

#include "LoRaEventProc.h"

/*!
 * Defines the application data transmission duty cycle
 */
uint32_t TxDutyCycleTime = APP_TX_DUTYCYCLE;

uint8_t AppCase = 0;

/*!
 * \brief   Prepares the payload of the frame based on application port
 */
void PrepareLoRaFrame( uint8_t port )
{

    switch( port )
    {    
    case 8: 
        { 
            uint8_t ptrIndex = 0;
                        
            //Point the pointer to position index of Tx Buffer
            LoRaApp.ApplicationPtrPos( ptrIndex );                         
                        
            /*!
            *  Read Pressure
            *  Appends 2 Bytes to TX buffer
            */
            LoRaApp.ApplicationCall( AppPressr );
            
            /*!
            *  Read Temperature
            *  Appends 1 Byte to TX buffer
            */
            LoRaApp.ApplicationCall( AppTemp );
            
            /*!
            *  Read Humidity
            *  Appends 1 Byte to TX buffer
            */
            LoRaApp.ApplicationCall( AppHumid );

            /*!
            *  Read Accelerometer
            *  Appends 6 Bytes to TX buffer
            *   Value       Orientation
            *   0x99 0x00   horizontal + faceup
            *   0x66 0x00   horizontal + facedown
            *   0x00 0x11   vertical
            */
            LoRaApp.ApplicationCall( AppAccl ); // Generate Accelerometer data bytes    


            break;
        }
       
        // IKAS sensor using Cayenne Payload Format
        case 9: 
        { 
#ifdef USE_CAYENNE_LPP        
            uint8_t ptrIndex = 0;
            
            uint16_t AppSize = 0;
            
            uint8_t tmp[2] = {0};
            
            //Point the pointer to position index of Tx Buffer
            LoRaApp.ApplicationPtrPos( ptrIndex );
            
            AppCase = AppCase > 3 ? 0 : AppCase;
            
            while( 1 )
            {            
                switch( AppCase ) 
                {
                    case 0: 
                    {
                        tmp[0] = 0;
                        tmp[1] = 115; // Data Type PRESSURE: 115
                        LoRaApp.ApplicationAppendData( tmp, 2 );
                        
                        /*!
                        *  Read Pressure
                        *  Appends 2 Bytes to TX buffer
                        */
                        LoRaApp.ApplicationCall( AppPressr );
                        
                        AppSize += maxLPPsize[AppCase];

                        break;
                    }
                    
                    case 1: 
                    {
                        tmp[0] = 1;
                        tmp[1] = 103; // Data Type TEMP: 103
                        LoRaApp.ApplicationAppendData( tmp, 2 );
                    
                        /*!
                        *  Read Temperature
                        *  Appends 1 Byte to TX buffer
                        */
                        LoRaApp.ApplicationCall( AppTemp );
                        
                        AppSize += maxLPPsize[AppCase];

                        break;
                    }
                    
                    case 2: 
                    {
                        tmp[0] = 2;
                        tmp[1] = 104; // Data Type HUMIDITY: 103
                        LoRaApp.ApplicationAppendData( tmp, 2 );
                        
                        /*!
                        *  Read Humidity
                        *  Appends 1 Byte to TX buffer
                        */
                        LoRaApp.ApplicationCall( AppHumid );
                        
                        AppSize += maxLPPsize[AppCase];

                        break;
                    }
                    
                    case 3: 
                    {
                        tmp[0] = 3;
                        tmp[1] = 113; // Data Type Accl: 113
                        LoRaApp.ApplicationAppendData( tmp, 2 );
                        /*!
                        *  Read Accelerometer                        
                        */
                        LoRaApp.ApplicationCall( AppAccl ); // Generate Accelerometer data bytes
                        
                        AppSize += maxLPPsize[AppCase];

                        break;
                    }
                }
                
                AppCase++;
                
                if( AppSize + maxLPPsize[AppCase] > LORAWAN_APP_DATA_SIZE )
                {
                    break;
                }
            }
                        
            AppDataSize = AppSize;            
#endif
            break;
        }

    // Push-Button Demo     
    case 11: 
        { 
            uint8_t ptrIndex = 0;

            //Point the pointer to position index of Tx Buffer
            LoRaApp.ApplicationPtrPos( ptrIndex );

            LoRaApp.ApplicationCall( AppPushButton ); // Transmit uplink counter   
            
            break;
        }
    
    case 13: 
    {
            uint8_t ptrIndex       =  0;
        uint8_t data_header[2] = {0};

            //Point the pointer to position index of Tx Buffer
            LoRaApp.ApplicationPtrPos( ptrIndex );

        data_header[0] = 0;
        data_header[1] = 0;
            
            LoRaApp.ApplicationAppendData( data_header, 2 ); 
            LoRaApp.ApplicationCall( AppButton ); // Transmit uplink counter   
        data_header[0] = 1;
        data_header[1] = 2;

            LoRaApp.ApplicationAppendData( data_header, 2 ); 
            LoRaApp.ApplicationCall( AppRotary ); // Transmit uplink counter   
        break;
    }

    default:
        break;
    }
}


/*!
 * \brief   Sets Interrupt for next payload transmission
 */
void InitNextTxInterrupt( uint8_t port )
{   
    switch( port )
    {  
    /* Push Button Demo 
       Send Packet Immedietly if PC0 = GND
    */  
    case 11: 
        {             
            volatile bool PushButtonStatus;

            PushButtonStatus = UsrButton;
            
            if(PushButtonStatus == 0)
            {
                // Send Pkt immedietly if PC = GND
                DeviceState = DEVICE_STATE_SEND;
                NextTx = true;
            }
            else
            {
                // Keep polling
                IsTxIntUpdate = true;
            }
            
            break;
        }   

    /* Compliance Test 
       Set Timer interrupt for next uplink
    */
    case 224:
        {               
            // Schedule next packet transmission
            TimerSetValue( &TxNextPacketTimer, COMPLIANCE_TX_DUTYCYCLE );
            TimerStart( &TxNextPacketTimer );
            break;
        }

    default:
        {
            // Schedule next packet transmission
            TimerSetValue( &TxNextPacketTimer, TxDutyCycleTime );
            TimerStart( &TxNextPacketTimer );
            break;
        }
    }

}

/*!
 * \brief   What to do during JOIN process ? blink/toggle LED etc.
 */
void JoinEvent( void )
{
}


/*!
 * \brief   What to do during TX ? blink/toggle LED etc.
 */
void TxEvent( void )
{
}

void RxEvent()
{
}

