/*
 / _____)             _              | |
( (____  _____ ____ _| |_ _____  ____| |__
 \____ \| ___ |    (_   _) ___ |/ ___)  _ \
 _____) ) ____| | | || |_| ____( (___| | | |
(______/|_____)_|_|_| \__)_____)\____)_| |_|
    (C)2015 Semtech

Description: User-defined applications such as GPS, Temp, Accelerometer, LED indications etc.
            Event based actions such as LED blink on Tx, LED toggle on downlink etc

License: Revised BSD License, see LICENSE.TXT file include in the project

Maintainer: Uttam Bhat
*/

#include "LoRaApp.h"

#ifdef USE_IKS01A1_SENSOR
float iks01a1_data;
int32_t Accl_Value[3] = {0};
#endif

#ifdef USE_CAYENNE_LPP
/*
.... Pressure
.... Temperature
.... Humidity
.... Accelerometer
*/
uint8_t maxLPPsize[4] = {4, 4, 3, 8};
#endif

bool VerticalStatus = false;


Application::Application( uint8_t * memptr )
{
    BuffAddr = memptr;
    memset( BuffAddr, 0, LORAWAN_APP_DATA_MAX_SIZE );
    BuffPtr = 0;    
}

Application::~Application( )
{
}

void Application::ApplicationAppendData( uint8_t *pData, uint8_t len )
{
    memcpy( BuffAddr + BuffPtr, pData, len );
    BuffPtr += len;
}

void Application::ApplicationPtrPos( uint8_t ptrPos )
{
    BuffPtr = ptrPos;
}

void Application::ApplicationCall( eAppType App )
{
    switch( App )
    {        
        // Appends 1 Byte to TX buffer
        case AppTemp:
        {    
#ifdef USE_IKS01A1_SENSOR 
                        
            temp_sensor2->GetTemperature(&iks01a1_data);
                                    
            printf("Temp = %f, %d\r\n", iks01a1_data, (int8_t) iks01a1_data);
                               
            if( ( BuffPtr + 1 ) <= LORAWAN_APP_DATA_SIZE )
            {
#ifdef USE_CAYENNE_LPP
                BuffAddr[BuffPtr++] = 0;
                BuffAddr[BuffPtr++] = (int8_t) ( iks01a1_data * 10 );
#else                
                BuffAddr[BuffPtr++] = (int8_t) iks01a1_data;
#endif                
            }
            
#endif            
            break;
        }
        
        // Appends 2 Bytes to TX buffer
        case AppPressr:
        {    
#ifdef USE_IKS01A1_SENSOR 
                        
            pressure_sensor->GetPressure(&iks01a1_data);
                                    
            printf("Pressure = %f, %d\r\n", iks01a1_data, (uint16_t) iks01a1_data);
                               
            if( ( BuffPtr + 2 ) <= LORAWAN_APP_DATA_SIZE )
            {
#ifdef USE_CAYENNE_LPP
                int16_t tmp;
                
                tmp =  (int16_t) ( iks01a1_data * 10 );
                BuffAddr[BuffPtr++] = ( tmp >> 8 ) & 0xFF;
                BuffAddr[BuffPtr++] = ( tmp ) & 0xFF;
#else                
                BuffAddr[BuffPtr++] = ( (int16_t) iks01a1_data >> 8 ) & 0xFF;
                BuffAddr[BuffPtr++] = ( (int16_t) iks01a1_data ) & 0xFF;
#endif                
            }
            
#endif            
            break;
        }
        
        // Appends 2 Bytes to TX buffer
        case AppHumid:
        {    
#ifdef USE_IKS01A1_SENSOR 
                        
            humidity_sensor->GetHumidity(&iks01a1_data);
                                    
            printf("Humidity = %f, %d\r\n", iks01a1_data, (uint8_t) iks01a1_data);
                               
            if( ( BuffPtr + 1 ) <= LORAWAN_APP_DATA_SIZE )
            {
#ifdef USE_CAYENNE_LPP
                BuffAddr[BuffPtr++] = (uint8_t) ( iks01a1_data * 2 );
#else                
                BuffAddr[BuffPtr++] = (int8_t) iks01a1_data;
#endif                
            }
            
#endif            
            break;
        }

        // Appends 6 Bytes to TX buffer
        case AppAccl:
        {  
#ifdef USE_IKS01A1_SENSOR 
                        
            accelerometer->Get_X_Axes(Accl_Value);
                                    
            printf("X/Y/Z = %d/%d/%d\r\n", Accl_Value[0], Accl_Value[1], Accl_Value[2]);
                               
            if( ( BuffPtr + 6 ) <= LORAWAN_APP_DATA_SIZE )
            {
                BuffAddr[BuffPtr++] = ( (int16_t) Accl_Value[0] >> 8 ) & 0xFF;
                BuffAddr[BuffPtr++] = ( (int16_t) Accl_Value[0] ) & 0xFF; 
                BuffAddr[BuffPtr++] = ( (int16_t) Accl_Value[1] >> 8 ) & 0xFF;
                BuffAddr[BuffPtr++] = ( (int16_t) Accl_Value[1] ) & 0xFF; 
                BuffAddr[BuffPtr++] = ( (int16_t) Accl_Value[2] >> 8 ) & 0xFF;
                BuffAddr[BuffPtr++] = ( (int16_t) Accl_Value[2] ) & 0xFF;                         
            }            
#endif            
            break;
        }       

        case AppPushButton:
        {   
            uint16_t PushButtonCnt;
            uint8_t *p = (uint8_t *) &PushButtonCnt;

            PushButtonCnt = LoRaMacUplinkStatus.UplinkCounter;
                
            memcpy( &BuffAddr[BuffPtr], p, sizeof(uint16_t) );
            
            break;
        }

    case AppButton:
    {
        int button_val = 0;
        
        if (1 == ext_button) button_val = 1;

        printf("button: %d\r\n", button_val);

        BuffAddr[BuffPtr++] = button_val;
        
        break;
    }

    case AppRotary:
    {
        uint16_t degree = (uint16_t)(ext_rotary.read() * 300);

        printf("rotary angle: %d\r\n", degree);

        BuffAddr[BuffPtr++] = ((degree * 100) >> 8) & 0xff;
        BuffAddr[BuffPtr++] = (degree * 100)        & 0xff;
        
        break;
    }

        default:
        {            
            break;
        }
    }
}

void CheckOrientation( void )
{
}
