#include "mbed.h"
#include "F746_GUI.hpp"
#include "SI7021.h"

SI7021 myTempRHsensor ( I2C_SDA, I2C_SCL, SI7021::SI7021_ADDRESS, 400000 );
Timer t;

Ticker newReading;
DigitalOut led1 ( LED1 );

//Déclaration pour le capteur
SI7021::SI7021_vector_data_t     myData;
SI7021::SI7021_status_t          mySI7021status;
uint32_t                         myState;

void readData ( void )
{
    myState++;
}

using namespace Mikami;

int main()
{
    int NumBoutonGroup1=0, NumBoutonGroup2=0, nLap = 1;

    Label titre(240, 2, "Dashboard F1", Label::CENTER, Font16);
    Label temperature(168, 110, "Temperature : ");
    Label humidite(168, 135, "Humidite : ");
    Label labelTime(168, 155,"Lap Time : ");
    Label pneu(260, 40,"Pneu");
    Label mode(57, 40,"Mode puissance",Label::CENTER);

    Button stand(10, 145, 60, 40, "Stand", Font12, GuiBase::ENUM_TEXT, GuiBase::ENUM_BACK, LCD_COLOR_BLUE, LCD_COLOR_RED);
    Button talk(10, 100, 60, 35, "Radio");
    Button start(400, 135, 60, 35, "Start", Font12, GuiBase::ENUM_TEXT, GuiBase::ENUM_BACK, LCD_COLOR_DARKGREEN);

    const string PNEU[4] = {"Soft", "Medium", "Hard", "Wet"};
    const string MODE[3] = {"1", "2", "3"};
    ButtonGroup bGroup1(168, 54, 66, 35,  4, PNEU, 2, 2, 4, 1, Font12, LCD_COLOR_WHITE, LCD_COLOR_BLACK);
    ButtonGroup bGroupMode(10, 54, 30, 35,  3, MODE, 2, 2, 3, 1, Font12, LCD_COLOR_WHITE, LCD_COLOR_BLACK);
    NumericLabel<int> bTouch(240, 112, "", Label::LEFT, Font12, LCD_COLOR_WHITE);
    NumericLabel<float> valTemp(290,110, "", Label::CENTER, Font12, LCD_COLOR_WHITE, LCD_COLOR_BLACK);
    NumericLabel<float> valHumi(260,135, "", Label::CENTER, Font12, LCD_COLOR_WHITE, LCD_COLOR_BLACK);
    NumericLabel<float> time(280,155, "", Label::CENTER, Font12, LCD_COLOR_WHITE, LCD_COLOR_BLACK);
    NumericLabel<int> lap(420,25, "");
    NumericLabel<int> valBias(110,260, "");
    NumericLabel<int> valDiff(350,260, "");

    SeekBar bias(20, 240, 200, 0, 100, 50, "0", "Bias","");
    SeekBar diff(260, 240, 200, 0, 100, 50, "0", "Differentiel","");

    bGroup1.Draw(0,0xFFFF0000,0xFFFFFFFF); //Red
    bGroup1.Draw(1,0xFFFFE800,0xFFFFFFFF); //Yellow
    bGroup1.Draw(2,0xFFFFFFFF,0xFF000000); //White

    // Reset le capteur
    mySI7021status   =   myTempRHsensor.SI7021_SoftReset ();
    // Configuration du capteur
    mySI7021status   =   myTempRHsensor.SI7021_Conf ( SI7021::SI7021_RESOLUTION_RH_12_TEMP_14, SI7021::SI7021_HTRE_DISABLED );
    // L'adresse de la fonction a utilisé ( readData ) l'intervale de temps ( 1s )
    newReading.attach( &readData, 0.1 );
    while (1) {

        NumBoutonGroup1=bGroup1.GetTouchedNumber();//Récupérer bouton touché
        if(bGroup1.GetTouchedNumber(NumBoutonGroup1)) {
            switch (NumBoutonGroup1) {
                case 0 :
                    bGroup1.Inactivate(0);
                    bGroup1.Activate(1);
                    bGroup1.Activate(2);
                    bGroup1.Activate(3);
                    bGroup1.Draw(1,0xFFFFE800,0xFFFFFFFF); //Yellow
                    bGroup1.Draw(2,0xFFFFFFFF,0xFF000000); //White
                    bGroup1.Draw(3);
                    break;
                case 1 :
                    bGroup1.Inactivate(1);
                    bGroup1.Activate(0);
                    bGroup1.Activate(3);
                    bGroup1.Activate(2);
                    bGroup1.Draw(0,0xFFFF0000,0xFFFFFFFF); //Red
                    bGroup1.Draw(2,0xFFFFFFFF,0xFF000000); //White
                    bGroup1.Draw(3);
                    break;
                case 2 :
                    bGroup1.Inactivate(2);
                    bGroup1.Activate(0);
                    bGroup1.Activate(1);
                    bGroup1.Activate(3);
                    bGroup1.Draw(0,0xFFFF0000,0xFFFFFFFF); //Red
                    bGroup1.Draw(1,0xFFFFE800,0xFFFFFFFF); //Yellow
                    bGroup1.Draw(3);
                    break;
                case 3 :
                    bGroup1.Inactivate(3);
                    bGroup1.Activate(0);
                    bGroup1.Activate(1);
                    bGroup1.Activate(2);
                    bGroup1.Draw(1,0xFFFFE800,0xFFFFFFFF); //Yellow
                    bGroup1.Draw(2,0xFFFFFFFF,0xFF000000); //White
                    bGroup1.Draw(0,0xFFFF0000,0xFFFFFFFF); //Red    
                    break;
            }
        }

        NumBoutonGroup2=bGroupMode.GetTouchedNumber();//Récupérer bouton touché
        if(bGroupMode.GetTouchedNumber(NumBoutonGroup2)) {
            switch (NumBoutonGroup2) {
                case 0 :
                    bGroupMode.Inactivate(0);
                    bGroupMode.Activate(1);
                    bGroupMode.Activate(2);

                    break;
                case 1 :
                    bGroupMode.Inactivate(1);
                    bGroupMode.Activate(0);
                    bGroupMode.Activate(2);

                    break;
                case 2 :
                    bGroupMode.Inactivate(2);
                    bGroupMode.Activate(0);
                    bGroupMode.Activate(1);
                    break;
            }
        }

        if(start.Touched()==1) {
            t.start();
            start.Inactivate();
        }

        // Si "stand" bouton appuyé, affichage retour au stand, on envoie plus aucune info
        if (stand.Touched())
            BlinkLabel warning(250, 180, "Retour au stand", Label::LEFT, Font16);

        if (bias.Slide()) {
            valBias.Draw("%d",bias.GetValue());//Récupérer valeur du bias
        }
        if (diff.Slide()) {
            valDiff.Draw("%d",diff.GetValue());//Récupérer valeur du differentiel
        }

        sleep();

        if ( myState == 1 ) {
            //Déclenche une nouvelle mesure d'humidité et de température
            led1    =  1;

            mySI7021status = myTempRHsensor.SI7021_TriggerHumidity ( SI7021::SI7021_NO_HOLD_MASTER_MODE );
            mySI7021status = myTempRHsensor.SI7021_TriggerTemperature( SI7021::SI7021_NO_HOLD_MASTER_MODE );
        } else if ( myState == 2 ) {
            // Lecture des mesures de température et d'humidité
            mySI7021status = myTempRHsensor.SI7021_ReadHumidity ( &myData );
            mySI7021status = myTempRHsensor.SI7021_ReadTemperatureFromRH ( &myData );
            
            //Affichage sur l'écran LCD des valeurs
            valTemp.Draw("%0.1f", myData.Temperature);
            valHumi.Draw("%0.0f", myData.RelativeHumidity);

            myState = 0; // Reset state
            led1 = 0;

        }
        time.Draw("%3.3f", t.read());

        if(t.read() >= 20) { //Condition fin de tour
            nLap++;
            t.reset();
        }

        lap.Draw("Lap %d/5",nLap);

        if(nLap == 5) { //Condition pour arreter le nombre de tour
            t.stop();
            t.reset();
            BlinkLabel finish(240, 180,"Course Termine",Label::CENTER);
        }
    }
}
