//-----------------------------------------------------------
//  NumericUpDown class
//      指定された桁を up/down する GUI 部品
//      6 桁まで可能
//
//  2018/03/12, Copyright (c) 2018 MIKAMI, Naoki
//-----------------------------------------------------------

#ifndef NUMERIC_UPDOWN_HPP
#define NUMERIC_UPDOWN_HPP

#include "F746_GUI.hpp"
#include "DelayedEnabler.hpp"

namespace Mikami
{
    class NumericUpDown
    {
    public:
        // digit    表示する桁数
        // initVal  最初に表示する数値
        NumericUpDown(uint16_t digit, uint16_t x0, uint16_t y0,
                      uint32_t initVal, uint32_t max, uint32_t min,
                      string unit = "", float delay = 0.2f);

        // Up, Down をタッチした場合は対応する数値を +1 または -1 する
        bool Touched();

        // 引数の数値を Label に表示する
        void Set(uint32_t frq);

        // Label に表示されている値を数値データとして取り出す
        uint32_t Get() { return value_; }

    private:
        const int DIGIT_;       // 桁数
        const int X0_, Y0_;
        const uint32_t MAX_;    // 最大値
        const uint32_t MIN_;    // 最小値
        const Array<uint32_t> POW10_;
        const static uint16_t XW_ = 45;
        const static int16_t SIZE_ = 6;

        static Point ptU_[3], ptD_[3];
     
        char fmt_[5];
        int numUd_;     // 一つ前にタッチしたボタンの番号
        uint32_t value_;

        DelayedEnabler delay_;
        Array<Label *> labels_;
        ButtonGroup *ud_;
        LCD_DISCO_F746NG &lcd_;

        // 数値の up, down に使う三角形の描画
        void UpDownSymbol(uint16_t x, uint16_t y, int k);

        // disallow copy constructor and assignment operator
        NumericUpDown(const NumericUpDown&);
        NumericUpDown& operator=(const NumericUpDown&);      
    };
}
#endif  // NUMERIC_UPDOWN_HPP
