#include "mbed.h"
#include "MAX14720.h"
#include "MAX30102.h"
#include "USBSerial.h"
#include "System.h"
#include "algorithm.h"

/// define the HVOUT Boost Voltage default for the MAX14720 PMIC
#define HVOUT_VOLTAGE 4500 // set to 4500 mV

#define MAX14720_I2C_SLAVE_ADDR (0x54)

#define MAX_BRIGHTNESS 255
#define MAX_SAMPLES_PER_CYCLE 500

///SpO2 variables
uint32_t aun_ir_buffer[MAX_SAMPLES_PER_CYCLE]; //IR LED sensor data
uint32_t aun_red_buffer[MAX_SAMPLES_PER_CYCLE];    //Red LED sensor data
uint32_t n_buffer_length; // Data buffer length
int32_t n_spo2; //SPO2 value
int8_t ch_spo2_valid;   //indicator to show if the SP02 calculation is valid
int32_t n_heart_rate;   //heart rate value
int8_t  ch_hr_valid;    //indicator to show if the heart rate calculation is valid

USBSerial usbSerial(0x0b6a, 0x0122, 0x0001, false);
/// I2C Master 2
I2C i2c2(I2C2_SDA, I2C2_SCL); // used by MAX14720, MAX30101, LIS2DH
MAX14720 max14720(&i2c2, MAX14720_I2C_SLAVE_ADDR);

DigitalIn INT(P4_0);
DigitalOut led(LED1);
int main()
{
    usbSerial.printf("Starting measurement...");
    int result;
    result = max14720.init();
    if (result == MAX14720_ERROR) {
        printf("Error initializing MAX14720");
    }
    max14720.boostEn = MAX14720::BOOST_ENABLED;
    max14720.boostSetVoltage(HVOUT_VOLTAGE);
    
    

    
}