#if defined(TARGET_NUCLEO_L432KC)

#define MODSERIAL_IRQ_REG ((USART_TypeDef*)_base)->CR1
#define DISABLE_TX_IRQ MODSERIAL_IRQ_REG &= ~USART_CR1_TXEIE
#define DISABLE_RX_IRQ MODSERIAL_IRQ_REG &= ~USART_CR1_RXNEIE
#define ENABLE_TX_IRQ MODSERIAL_IRQ_REG |= USART_CR1_TXEIE
#define ENABLE_RX_IRQ MODSERIAL_IRQ_REG |= USART_CR1_RXNEIE

#define MODSERIAL_READ_REG  ((USART_TypeDef*)_base)->RDR
#define MODSERIAL_WRITE_REG ((USART_TypeDef*)_base)->TDR
#define MODSERIAL_READABLE ((((USART_TypeDef*)_base)->ISR & USART_ISR_RXNE) != 0)
#define MODSERIAL_WRITABLE ((((USART_TypeDef*)_base)->ISR & USART_ISR_TXE) != 0)

#define RESET_TX_FIFO (((USART_TypeDef*)_base)->RQR & USART_RQR_TXFRQ)
#define RESET_RX_FIFO (((USART_TypeDef*)_base)->RQR & USART_RQR_RXFRQ)

#define RX_IRQ_ENABLED ((MODSERIAL_IRQ_REG & USART_CR1_RXNEIE) != 0)
#define TX_IRQ_ENABLED ((MODSERIAL_IRQ_REG & USART_CR1_TXEIE) != 0)


#endif
