//-----------Bibilioteker------------//
#include "mbed.h"
#define BUTTON1 p18
#include <stdio.h>
#include <errno.h>
#include "EthernetInterface.h"

#include "FATFileSystem.h"
#include "SDBlockDevice.h"
// Physical block device, can be any device that supports the BlockDevice API
SDBlockDevice bd(
    MBED_CONF_SD_SPI_MOSI,
    MBED_CONF_SD_SPI_MISO,
    MBED_CONF_SD_SPI_CLK,
    MBED_CONF_SD_SPI_CS);
// File system declaration
FATFileSystem fs("fs");

Serial pc(USBTX, USBRX);        // Serial kommunikasjon med PC
SPI bus(p11, p12, p13);         // p11-mosi brukes ikke, p12-miso kobles til pinne 3 på sensoren, p13-sck kobles til pinne 4 på sensoren
DigitalOut slave_1(p19);        // p20-SS, koble til pinne 5 på sensor 1
DigitalOut slave_2(p18);        // p19-SS, koble til pinne 5 på sensor 2
DigitalOut slave_3(p17);        // p18-SS, koble til pinne 5 på sensor 3
EthernetInterface net;          //Ethernet interface
TCPSocket socket;               //TCP socket
Timer tid;                      // Timer
Ticker t;                   // Tikker for å kjøre avlesningen to ganger i sekundet.


//--------------Funksjoner-------------//
void data(float s1, float av1,float s2, float av2,float s3, float av3); // Oppretting av et array for webaddressen
void send(char *arr, int lengde);                                       // Sender data til mottat webaddresse
void sensor();                                                          // Avlesning av Sensor verdiene
void omregning(int a, float speed);                                     // Omregning av avlesningen

//----------Globale variable-----------//
int i=0, ant=0;                 // Variabelen i er til for å forenkle valget av de tre sensorene, ant er der for antallet avlesninger
int avlest[3];                  // Array for lagring av avlest verdi
float trykk[3];                 // Array for lagring av omregnet trykkverdi
float fart[3];                  // Array for lagring av omregnet fartverdi
float sum_fart[3];              // Array for summering av farten
float avvik[3];                 // Array for lagring av standardavviket på vannhastigheten
float gjennomsnitt[3];          // Array for lagring av gjennomsnittelig vannhastighet

//--------Definisjoner----------------//
#define ut_min 0x0666           // Minste avleste verdi defineres
#define ut_max 0x399A           // Maksimum avlest verdi defineres
#define trykk_min -6000         // Minimale trykkverdi i Pascal på sensoren defineres
#define trykk_max 6000          // Maksimale trykkverdi i Pascal på sernsoren defineres

int main()
{
    fs.mount(&bd);  // Try to mount the filesystem
    pc.printf("\nSetter opp nettverksforbindelse");
    net.connect();                  // Setter opp nettforbindelse
    pc.printf("\nTilkoblet nettet");

    const char *ip = net.get_ip_address();// Innhenter IP addresse
    printf("\nIP address is: %s\n\n", ip ? ip : "No IP");

    bus.format(16,0);               // Oppsett av SPI dataformat, (16 bit data, mode 0)
    // mode 0 = (klokke verdi ved tomgang = 0, data avleses ved opp-flanke av klokkepuls)
    bus.frequency(800000);          // Velger frekvensen på kommuniaksjonsklokken til 800KHz
    slave_1 = slave_2 = slave_3 = 1;// Ingen slave valgt
    pc.printf("\n\tSensor 1\t\t\tSensor 2\t\t\tSensor 3\t\n");
    pc.printf("Inn\tP\t\t[m/s]\tInn\tP\t\t[m/s]\tInn\tP\t\t[m/s]\n");
    t.attach(&sensor,0.5);          // Setter igang Tikker med sensor() fuknsjonen som kalles 2 ganger i sekundet
    tid.start();                    // Starter timer


    //-----------Evig løkke-------------//
    while(1) {
        static bool sist = false;       // Dette er en liten kode for å sende kun en gang.
        while (16 < tid.read()) {       // Tiden må ha passert 16 sekunder for dette blir sant
            if(ant==144) {              // Tester på om det er blitt utført 144 målinger
                ant=0;                  // Antallet målinger nullstilles for en ny runde
                if(!sist) {             // Tester om ikke sist
                    sist = true;        // Setter sist til sann, slik at sendingenn kun utføres en gang etter 16 sekunder
                    t.detach();         // Detacher fuknsjonen sensor fra Tikker for å kunne sende uavbrutt.
                    data(gjennomsnitt[0], avvik[0], gjennomsnitt[1], avvik[1], gjennomsnitt[2], avvik[2]);// Sender data
                    for(int c=0; c<3; c++) { // En For løkke for å nullstille de Globale variablene
                        avlest[c]=0;
                        gjennomsnitt[c]=0.0;
                        avvik[c]=0.0;
                        trykk[c]=0.0;
                        fart[c]=0.0;
                        sum_fart[c]=0.0;
                    }
                    t.attach(&sensor,0.5);// Tilegner funksjonen sensor til Tikker igjen for avlesning av sensor verdier

                    tid.stop();         // Stopper Timer og resetter for ny runde
                    tid.reset();
                }
            } else {                    // En del av sending en gang
                sist=false;
            }
        }

        tid.start();                    // Starter timer igjen for nye 16 sekunder
        
    }
}

//----------Sensor funskjonen------------//
void sensor()
{
    for(i=0; i<3; i++) {                // En for løkke for å lese av alle tre sensorene
        if(i==0) {
            slave_1 = 0;                // Velger sensor 1 som slave
            avlest[i] = bus.write(0x0001);// Sender dummy command for å få respons
            slave_1 = 1;                // Slipper slaven
        }

        if(i==1) {
            slave_2 = 0;                // Velger sensor 2 som slave
            avlest[i] = bus.write(0x0001);// Be om trykk verdi avlesning
            slave_2 = 1;                // Slipper slaven
        }

        if(i==2) {
            slave_3 = 0;                 // Velger sensor 3 som slave
            avlest[i] = bus.write(0x0001);// Be om trykk verdi avlesning
            slave_3 = 1;                // Slipper slaven
        }

        trykk[i]=1.0*(avlest[i]-ut_min)*(trykk_max-trykk_min)/(ut_max - ut_min)+trykk_min;  // Omregningsformel gitt fra produsenten
        fart[i]= sqrt(abs(2*trykk[i])/1000);                                                // Omregner trykket til hastighet
        pc.printf("%X\t%.2f\t%.2f\t", avlest[i], trykk[i], fart[i]); // Hviser innlest og omregnet verdier
        omregning(i, fart[i]);

    }
    pc.printf("\n");            // New line for at visningen på Teraterm blir forståelig
    FILE *fp = fopen("/fs/verdier.csv","a");// Åpner fila verdier for skriving
    fprintf(fp,"%X;%f;%f; ;%X;%f;%f; ;%X;%f;%f; ;", avlest[0], trykk[0], fart[0], avlest[1], trykk[1], fart[1], avlest[2], trykk[2], fart[2]); // Loggfører verdien
    fprintf(fp,"\n");  //ny linje i csv filen
    fclose(fp);
}

//----------Omregningsfunskjonen------------//
void omregning(int a, float speed)
{
    ant++;                      // Inkrementerer den globale variabelen ant med en
    sum_fart[a] = sum_fart[a] + speed;// summerer alle hastigheter for gjennomsnitt utregning
    if(ant==144) {
        for(int b=0; b<3; b++) { // Regner ut gjennomsnittet for alle tre hastigheten
            gjennomsnitt[b]=sum_fart[b]/48;
            avvik[b]=sqrt(((pow(sum_fart[b]-gjennomsnitt[b], 2)))/(48-1));
            pc.printf("\n Gjennonsnitt: %.2f\t Standardavvik: %.2f\n",gjennomsnitt[b],avvik[b]);
        }
        pc.printf("antallet: %d\n",ant);
    }
}

//----------Sende funksjon------------//
void send(char *arr, int lengde)
{
    socket.open(&net);
    socket.connect("api.thingspeak.com", 80);

    // Sender array til ThingSpeak
    socket.send(arr, lengde);
    pc.printf("\nSendte:%s\n\n",arr);

    //Lukker socket
    socket.close();
}

//----------Dataene som skal sendes------------//
void data(float s1, float av1,float s2, float av2,float s3, float av3)
{
    char a[200];            // Oppretter buffer ////Fyller buffer med update link med riktig felt og verdi
    sprintf (a, "GET https://api.thingspeak.com/update?api_key=TT0INEEL44E31AHP&field1=%.2f&field2=%.2f&field3=%.2f&field4=%.2f&field5=%.2f&field6=%.2f\r\n",s1,av1,s2,av2,s3,av3);
    send(a,200);            //Kaller opp funksjonen send for å sende til thingspeak
    pc.printf("\n\tSensor 1\t\t\tSensor 2\t\t\tSensor 3\t\n");
    pc.printf("Inn\tP\t\t[m/s]\tInn\tP\t\t[m/s]\tInn\tP\t\t[m/s]\n");
}