#include "mbed.h"
#include "TextLCD.h"

//#include "MAX6662.h"
// Create the local filesystem under the name "local"

LocalFileSystem local("local");
TextLCD lcd(p24, p25, p26, p27, p28, p29, p30); // rs, rw, e, d0, d1, d2, d3
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalIn button(p12);

AnalogIn grx(p16);  // gyroscope x-axis
AnalogIn gry(p17);  // gyroscope y-axis
AnalogIn acx(p18);  // accelerometer x-axis
AnalogIn acy(p19);  // accelerometer y-axis
AnalogIn acz(p20);  // accelerometer z-axis



char direct[]= "local";
char file[20];
char next_file[20];
int file_no;
int count;
bool not_found;
bool check;

//*********************************************
//sub for filename search
bool exists(char * root, char *filename) {

    DIR *d;
    struct dirent *p;
    d = opendir("/local");

    //printf("\nList of files in the directory %s:\n", root);
    bool found = false;
    if ( d != NULL ) {
        while ( !found && (p = readdir(d)) != NULL ) {
            //printf(" - %s\n", p->d_name);
            if ( strcmp(p->d_name, filename) == 0 )
                found = true;
        }
    }
    closedir(d);
    not_found=!found;
    return found;
}

//*********************************************

// this routine could check the last number of file it is
// last file _no = file_no - 1;

//not_found=false; // intial


//*********************************************
//sub to search for filename
int search( void ) {

    not_found=false;
    led1=button;
    file_no=1;
    count=0;

    while (not_found==false) {
        sprintf(file, "TEMP%d.CSV", file_no);
//        wait(.1);
        if ( exists(direct, file) ) {
          
           // lcd.cls();
            //lcd.locate(0,0);
            //lcd.printf("Found %s",file);
        } else {

            lcd.cls();
            //lcd.locate(0,0);
            lcd.printf("Not %s", file);
        }
        file_no++;
       // lcd.locate(0,1);
        //lcd.printf("%d", file_no-1);
    }
    check=1;
    led2=check;
    return file_no;
}

//***************************************************

//**************************************************
//sub to delay input button
//avoid bouncing effect

int button_delay(bool b) {
    bool c = false;
    if (b==true) {
        wait(.5);
        c=true;
    } else {
        c=false;
    }
    return c;
}

//*******************************************************
//main program start here

bool sw;
int no;

int main() {

    while (1) {


        sw=button_delay(button);
        led1=sw;

        if (sw == false and no == 0) {
            led3=1;
            no=search();
            lcd.locate(0,1);
            lcd.printf("it is %d", no-1);
            sprintf(next_file, "/local/temp%d.csv", file_no-1);
        }


        if (sw == true and no != 0) {
            no=0;
            led3=0;

            FILE *fp = fopen(next_file, "w");
            //while (button) {
            while (button_delay(button)) {
                led2 = !led2;
                // time,data<cr>
                fprintf(fp,"%.2f,%.2f,%.2f,%.2f,%.2f\n",grx.read()*3.3, gry.read()*3.3,acx.read()*3.3,acy.read()*3.3,acz.read()*3.3);
                //pc.printf("%f,%f,%f\n",acx.read(),acy.read(),acz.read());
                lcd.locate(0,0);
                lcd.printf("gx=%.2f,gy=%.2f",grx.read()*3.3, gry.read()*3.3);
                //lcd.printf("%.2f", f);
                lcd.locate(0,1);
                lcd.printf("ax=%.2f,ay=%.2f,az=%.2f",acx.read()*3.3,acy.read()*3.3,acz.read()*3.3);
                wait (.01);
            }
            fclose(fp);
           // lcd.cls();
            //lcd.locate(0,0);
            ///lcd.printf("Press button to start");
           // wait(.1);
        }
    }
}



