#include "mbed.h"
#include "TextLCD.h"

SPI _spi(p5,p6,p7);                             //mosi, miso, sck
DigitalOut cs(p8);                              // chip select of MCP3008
TextLCD lcd(p24, p25, p26, p27, p28, p29, p30); // rs, rw, e, d0, d1, d2, d3


int main() {
        int _data1;
        int _data2;
        cs=1;                       // deselect everything
        wait(0.001);
        _spi.format(8,0);           //see page1 of MCP3008 manual
        _spi.frequency(1000000);    //see page4 of MCP3008 manual

//******************************************************************
//    MCP3008 clock sequence and control bits
//Once cs low, send start bit ==> 0x01  Not expecting any return
//next, send control bits   Expecting return B9, B8
//next, send anything, say 0x00, expecting return B7-B0
//next shift B9,B8 left 8bits
//next merge B9,B8 and B7-B0 to form 16bits data
//next, mask off bit15-bit10, to get a clean 10 bit data
//*******************************************************************

//*******************************************************************
//      1st 8bits         2nd 8bits           3rd 8bits
//ch0      0x01              0x80                 0x00
//ch1      0x01              0x90                 0x00
//ch2      0x01              0xA0                 0x00
//ch3      0x01              0xB0                 0x00
//ch4      0x01              0xC0                 0x00
//ch5      0x01              0xD0                 0x00
//ch6      0x01              0xE0                 0x00
//ch7      0x01              0xF0                 0x00
//*******************************************************************

   

    while (1) {

//ch0.
        cs=0;                               //cs low. start data collection
        _spi.write(0x01);                   //write start bit. Not expecting return
        _data1=_spi.write(0x80);            //write control bit, expecting return B9, B8
        _data2=_spi.write(0x00);            //write anything, expecting return B7-B0
        int ch0 =(_data1<<8) | _data2;          //merge two 8bits data becoming 16bits data
        ch0 = ch0 & 0x03FF;                 // mask off bit15 - bit10
        cs=1;                               //cs high. end of data collection

//ch1   
        cs=0;                      
        _spi.write(0x01);
        _data1=_spi.write(0x90);
        _data2=_spi.write(0x00);
        int ch1 =(_data1<<8) | _data2;
        ch1 = ch1 & 0x03FF;
        cs=1;


//ch2   
        cs=0;                      
        _spi.write(0x01);
        _data1=_spi.write(0xA0);
        _data2=_spi.write(0x00);
        int ch2 =(_data1<<8) | _data2;
        ch2 = ch2 & 0x03FF;
        cs=1;


//ch3   
        cs=0;                      
        _spi.write(0x01);
        _data1=_spi.write(0xB0);
        _data2=_spi.write(0x00);
        int ch3 =(_data1<<8) | _data2;
        ch3 = ch3 & 0x03FF;
        cs=1;


//ch4   
        cs=0;                      
        _spi.write(0x01);
        _data1=_spi.write(0xC0);
        _data2=_spi.write(0x00);
        int ch4 =(_data1<<8) | _data2;
        ch4 = ch4 & 0x03FF;
        cs=1;


//ch5   
        cs=0;                      
        _spi.write(0x01);
        _data1=_spi.write(0xD0);
        _data2=_spi.write(0x00);
        int ch5 =(_data1<<8) | _data2;
        ch5 = ch5 & 0x03FF;
        cs=1;


//ch6   
        cs=0;                      
        _spi.write(0x01);
        _data1=_spi.write(0xE0);
        _data2=_spi.write(0x00);
        int ch6 =(_data1<<8) | _data2;
        ch6 = ch6 & 0x03FF;
        cs=1;


//ch7  
        cs=0;                      
        _spi.write(0x01);
        _data1=_spi.write(0xF0);
        _data2=_spi.write(0x00);
        int ch7 =(_data1<<8) | _data2;
        ch7 = ch7 & 0x03FF;
        cs=1;


//Display the results
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("%d%d%d%d",ch0,ch1,ch2,ch3);
        lcd.locate(0,1);
        lcd.printf("%d%d%d%d",ch4,ch5,ch6,ch7);

        wait(0.01);
    }
}

