#include"mbed.h"
#define hallSensor 0xE000 //hall sensor intput H1=>PB13, H2=>PB14, H3=>PB15

Serial pc(USBTX,USBRX);
PortIn GrayCode(PortB,hallSensor);
InterruptIn mybutton(PC_13);
DigitalOut Direction(PC_9);
DigitalOut myled(LED1);
AnalogIn ana(PA_0);
PwmOut mypwm(PC_8);
Timer t;

void rx_interrupt();
void button();
void loop();
void motor(float dt,int dir);
int grayToBinary(int num);
int ReadHall();
int ReadPosition();

int count = 0;
int PrePosition = ReadHall();
int NowPosition;
int result;
float stop = 0.1;
int rx_input = 15;
int forward = 1;
int reverse = 0;
int i = 0;
int j = 0;
const int buff = 32;
char rx_in[buff];

int main(){
    pc.baud(1843200);
    pc.attach(&rx_interrupt, Serial::RxIrq);
    mybutton.fall(&button);
    mypwm.period_ms(1);
    motor(stop,reverse);
    
    float home = 0;
    float sp_home = 0.118;
    
    loop();
    
    motor(sp_home,reverse);
    wait_ms(120);
    
    while(home <= 0.04){
        home = ana.read();
        motor(sp_home,reverse);
        sp_home+=0.000003;
        if(sp_home >= 0.13) sp_home = 0.13;
        wait_ms(1);
        }
        
    motor(stop,reverse);    
    
    count = 0;
    long int tp = 15*13;
    long int ap = 0;
    long int err = 0;
    long int integral = 0;
    float duty = stop;
    float Kp = 10;
    float Ki = 0.0000001;
    j = 0;
    t.start();
    while(1){
        
        ap = ReadPosition();
        tp = rx_input*13;
        if (tp >= 1560) tp = 1560;
        if (tp <= 195)  tp = 195;
        err = tp - ap;
        integral += abs(err);
        duty = (((0.8/2340)*float(abs(err)))*Kp)+(integral*Ki)+0.1;
        if (duty >= 0.9) duty = 0.9;
        if (duty <= 0.1) duty = 0.1;
        if (err > 0){ 
            motor(duty,forward);
            }
        else{
            if(err == 0){
                motor(stop,forward);
                integral = 0;
                }
            else{ 
                motor(duty,reverse);
                }
            } 
        }
    }

void button(){j = 1;}

void loop(){
    j = 0;
    while(j == 0){
        myled = 1;}
    myled = 0;
    }
    
void motor(float dt,int dir){
    mypwm.write(dt);
    Direction = dir;
    }  
    
void rx_interrupt(){
    while (pc.readable()) {
        rx_in[i] = pc.getc();
        pc.putc(rx_in[i]);
        if((rx_in[i] == '\r')||(rx_in[i] == '\n')||(i > buff)){
            rx_input = atoi(rx_in);
            i = 0;
            for(int k = 0;k < buff;k++){
                rx_in[k] = '\0';}
            pc.printf("\r\n");    
            }
        else{
            i++;
            }    
    }   
}     
    
int grayToBinary(int num){
    int mask;
    for (mask = num >> 1; mask != 0; mask = mask >> 1)
    {
        num = num ^ mask;
    }
    return num;
}

int ReadHall(){
    int gray;
    int dec;
    gray = GrayCode.read() >> 13;//change from 0xE000 to 0x0007    
        dec = grayToBinary(gray); 
        if(dec == 7){
            dec = 5;
        } 
        return dec;//return hall sensor position 1 2 3 4 5 6
    }

int ReadPosition(){
        NowPosition = ReadHall();
        result = NowPosition - PrePosition;
        
        if(abs(result) > 3){
            if(result > 0){
                result-=6;
            }
            else{
                result+=6;
            } 
        }
        count = count - result;
        PrePosition = NowPosition;
        return count;
        }    