#include "mbed.h"
#ifndef MBED_BMA180_H
#define MBED_BMA180_H

/******************DEFINED REGISTERS******************/
#define CHIPID              0x00
#define VERSION         0x01
#define ACCXLSB         0x02
#define ACCXMSB         0x03
#define ACCYLSB         0x04
#define ACCYMSB         0x05
#define ACCZLSB         0x06
#define ACCZMSB         0x07
#define TEMP            0x08
#define CTRL_REG0       0x0D
#define BWTCS           0x20
#define DIS_I2C         0x27    // bit0 must be 1 for SPI
#define CTRL_REG3       0x21    // bit1 = new_data_int
#define RESET           0x10    // soft reset
#define RANGE           0x35    // 2g = 010

class BMA180 {
public:
    BMA180(PinName _sdi, PinName _sdo, PinName _sck, PinName _cs, PinName _interrupt);
    int validate(char idAddress, char verAddress);
    void initBMA180(void);
    void reset(void);
    void readAxis(void);
    void writeReg(uint8_t address, char data);
    char readReg(uint8_t address);
    void disInt(void);

private:
    SPI spi;
    DigitalOut _csb;
    DigitalOut _interrupt;
};

#endif