#include "mbed.h"
#include "BMA180.h"

//Serial pc(USBTX, USBRX); // tx, rx

BMA180::BMA180(PinName sdi, PinName sdo, PinName sck, PinName csb, PinName interrupt) : _csb(csb), _interrupt(interrupt), spi(sdi, sdo, sck){
             // mosi, miso, sclk
    _csb = 1;
    _interrupt = 0;
}

int BMA180::validate(char id, char ver) {
    char readID;
    int value = 0;
    
    readID = readReg(id);
    
    if(readID == 3) {
        value = 1;
    } else {
        //pc.printf("Lost Connection");
        value = -1;
    }
    return value;
}

void BMA180::initBMA180(void) {
    char readVersion, readID;
    char byte; 
    
    readID = readReg(CHIPID);
    readVersion = readReg(VERSION);
    
    if(readID == 3) {
        //pc.printf("Connected to BMA180\n\r");
        //pc.printf("BMA180 Version: %d\n\r", readVersion);
        
        reset();                                           
    
        byte = readReg(CTRL_REG0);     
        byte |= 0x10;                                           // Set bit4 to 1 to enable self test and unlock image writing
        writeReg(CTRL_REG0, byte);    
    
        byte = readReg(DIS_I2C);                               // Read register
        //pc.printf("\n\rDisable I2C Before: %0.3X ", byte);
        byte |= 0x01;                                          // Set bit0 to 1 for only SPI
        writeReg(DIS_I2C, byte);                               // Set SPI and disable I2C as per pg 31 of datasheet
        byte = readReg(RANGE);
        //pc.printf("After: %0.3X", byte);
    
        byte = readReg(RANGE);                                 // Read register
        //pc.printf("\n\rRange Before: %0.3X ", byte);
        byte &= 0xFB;                                          // Set bit3,2,1 to 010 for 2g
        byte |= 0x02;
        writeReg(RANGE, byte);
        byte = readReg(RANGE);
        //pc.printf("After: %0.3X", byte);
    
        byte = readReg(CTRL_REG3);
        //pc.printf("\n\rRegister 3 Before: %0.3X ", byte);
        byte |= 0x02;                                           // Set bit1 to 1 to enable new data interrupts
        byte |= 0x40;                                           // Set bit6 to 1 to enable slope mode
        byte |= 0x80;                                           // Set bit6 to 1 to enable slope alert
        writeReg(CTRL_REG3, byte);
        //pc.printf("After: %0.3X", byte);
        //pc.printf("Interrupt is enabled.");
    
        byte = readReg(CTRL_REG0);
        byte &= 0xEF;                                           // Set bit4 to 0 to disable self test and lock image writing
        writeReg(CTRL_REG0, byte);
        
        //pc.printf("\n\rBMA initialization complete.\n\r");
        
    } else {
        //pc.printf("Not connected to BMA180! ReadVersion:  %d ReadID:  %d\n\r", readVersion, readID);
    }      
}

void BMA180::reset(void) {
    writeReg(RESET, 0xB6);
    wait_ms(10);
    //pc.printf("Soft Reset, EEPROM Copied\n\r");
}

void BMA180::readAxis(void) {
    int x_msb, y_msb, z_msb;
    char x_lsb, y_lsb, z_lsb;
    short ax, ay, az;
    float afx, afy, afz;
    
    x_lsb = readReg(ACCXLSB);                              // Read X LSB register
    x_msb = readReg(ACCXMSB);                              // Read X MSB register
    ax = (x_msb << 8) | x_lsb;                             // Concatinate X MSB and LSB
    ax = ax >> 2;                                          // Remove unused first 2 LSB (16 bits to 14 bits)
    afx = (float)ax*3/16384;                               
    
    y_lsb = readReg(ACCYLSB);                              // Read Y LSB register
    y_msb = readReg(ACCYMSB);                              // Read Y MSB register
    ay = (y_msb << 8) | y_lsb;                             // Concatinate Y MSB and LSB
    ay = ay >> 2;                                          // Remove unused first 2 LSB
    afy = (float)ay*3/16384;
                                
    z_lsb = readReg(ACCZLSB);                              // Read Z LSB register
    z_msb = readReg(ACCZMSB);                              // Read Z MSB register
    az = (z_msb << 8) | z_lsb;                             // Concatinate Z MSB and LSB
    az = az >> 2;                                          // Remove unused first 2 LSB
    afz = (float)az*3/16384;                        
    
    
    //pc.printf("\n\rX: %05f Y: %05f Z: %05f", afx, afy, afz);
}

void BMA180::writeReg(uint8_t address, char data) {
    address &= 0x7F;                                        // Set bit7 to 0 for write mode
    _csb = 0;                                               // Select the device
    wait_us(2);
    spi.write(address);                                     // Send to data register location
    wait_us(2);
    spi.write(data);                                        // Send value to register
    wait_us(2);
    _csb = 1;                                               // Deselect the device
}

char BMA180::readReg(uint8_t address) {
    char byte;

    address |= 0x80;                                        // Set bit7 to 1 for read mode
    _csb = 0;                                               // Select the device
    wait_us(2);
    spi.write(address);                                     // Send to data register location
    wait_us(2);
    byte = spi.write(address);                              // Get data
    wait_us(2);
    _csb = 1;                                               // Deselect the device
    wait_us(2);
    return byte;
}

void BMA180::disInt(void) {
    char byte;
    
    byte = readReg(CTRL_REG0);     
    byte |= 0x10;                                           // Set bit4 to 1 to enable self test and unlock image writing
    writeReg(CTRL_REG0, byte);
    
    byte = readReg(CTRL_REG3);                              // Unlock image writing
    byte &= 0xFD;                                           // Set bit1 to 0 to disable interrupt
    writeReg(CTRL_REG3, byte);
        
    byte = readReg(CTRL_REG0);
    byte &= 0xEF;                                           // Set bit4 to 0 to disable self test and lock image writing
    writeReg(CTRL_REG0, byte);
}
