
#ifndef SPHEREDEMO_H
#define SPHEREDEMO_H

#include "Graphics.h"
//#include "GFXFb.h"

class SphereDemo {
public:

    /** Set the address of the frame buffer to use.
     *
     *  It is the content of the frame buffer that is shown on the
     *  display. All the drawing on the frame buffer can be done
     *  'offline' and whenever it should be shown this function
     *  can be called with the address of the offline frame buffer.
     *
     *  @param pFrameBuf  Pointer to the frame buffer, which must be
     *                    3 times as big as the frame size (for tripple
     *                    buffering).
     *         dispWidth  The width of the display (in pixels).
     *         dispHeight The height of the display (in pixels).
     *         loops      Number of loops in the demo code.
     *         delayMs    Delay in milliseconds between schreen updates.
     *
     *  @returns
     *       none
     */
    SphereDemo(void *pFrameBuf, int dispWidth, int dispHeight);
    
    void run(uint32_t loops, uint32_t delayMs);

private:

    enum Constants {
        N         = 1024, // Number of dots
        SCALE     = 8192,
        INCREMENT = 512,  // INCREMENT = SCALE / sqrt(N) * 2
        SPEED     = 5
    };

    int32_t windowX;
    int32_t windowY;
    uint16_t *pFrmBuf;
    uint16_t *pFrmBuf1;
    uint16_t *pFrmBuf2;
    uint16_t *pFrmBuf3;
    
    Graphics graphics;
    //Display* _disp;

    
    int16_t sine[SCALE];
    int16_t cosi[SCALE];
    
    uint16_t fastsqrt(uint32_t n) const;
    void matrix(int16_t xyz[3][N], uint8_t rgb[3][N]);
    void rotate(int16_t xyz[3][N], uint8_t rgb[3][N], uint16_t angleX, uint16_t angleY, uint16_t angleZ);
    void draw(int16_t xyz[3][N], uint8_t rgb[3][N]);
};

#endif /* SPHEREDEMO_H */

