#include "mbed.h"
#include "DMBoard.h"
//#include "lpc_swim.h"
//#include "lpc_swim_font.h"
#include "SphereDemo.h"

bool abortTest;

int main()
{
  
  DMBoard::BoardError err;
  DMBoard* board = &DMBoard::instance();
  RtosLog* log = board->logger();
  Display* disp = board->display();
  abortTest=false;
  
  do {
    err = board->init();
    if (err != DMBoard::Ok) {
      log->printf("Failed to initialize the board, got error %d\r\n", err);
      break;
    }
    
    //log->printf("\n\nHello World!\n\n");
    
   // SWIM_WINDOW_T win;
    void* fb = disp->allocateFramebuffer();
    if (fb == NULL) {
      log->printf("Failed to allocate memory for a frame buffer\r\n");
      err = DMBoard::MemoryError;
      break;
    }
    
 
    // Start display in default mode (16-bit)
    Display::DisplayError disperr = disp->powerUp(fb);
    if (disperr != Display::DisplayError_Ok) {
      log->printf("Failed to initialize the display, got error %d\r\n", disperr);
      break;
    }
    
    
//memset((void*)fb, 0x0, lcdCfg.width*lcdCfg.height*2 *3);

        SphereDemo sphereDemo(fb, disp->width(), disp->height());//(uint8_t *)frameBuf1
        while (1) {
            sphereDemo.run(750, 50);
            //.RESET_FLAG;
        }
    
  } while(false);

  if (err != DMBoard::Ok) {
    log->printf("\nTERMINATING\n");
    wait_ms(2000); // allow RtosLog to flush messages
    mbed_die();
  }  

  while(true) {
  }   
}
