#include "mbed.h"
#define PROTOPLATFORM
//#define MBEDPLATFORM
#include "Protocol/modbus.h"

//LEDs
#define LED_1 (LED1)
#define LED_2 (LED1)

//Serial(1) rs232
#define RS232_TX (p13)
#define RS232_RX (p14)

//Serial(2) rs232/ttl/iphone
#define TTL_TX (p28)
#define TTL_RX (p27) 
#define TTL_GND (p26) 

//Console
#define CONSOLETX (USBTX)
#define CONSOLERX (USBRX)




//MODBUS STUFF
#define LOOP             1
#define SLAVE         0x01
#define ADDRESS_START    4096
#define ADDRESS_END      4100


 int nb = ADDRESS_END - ADDRESS_START;;
       
        uint8_t tab_rq_status[ADDRESS_END - ADDRESS_START];
        uint8_t tab_rp_status[ADDRESS_END - ADDRESS_START];
        uint16_t tab_rq_registers[ADDRESS_END - ADDRESS_START];
        uint16_t tab_rp_registers[ADDRESS_END - ADDRESS_START];
        
DigitalOut myled(LED_1);
Serial console_port(CONSOLETX, CONSOLERX);

Serial serial(RS232_TX,RS232_RX);

modbus_param_t mb_param;
       uint8_t query[MIN_QUERY_LENGTH];
        uint8_t response[MAX_MESSAGE_LENGTH];
        
void handleInterrupt() {

     int ret;
        int nb_fail;
        int nb_loop;
        int addr;
        
        
           
 printf("**");
      
        
        modbus_receive(&mb_param, query, response);
   
   //      if (ret > 0) {
                int offset;
                int i;

              //  ret = modbus_receive(mb_param, query, response);
        
                offset = mb_param.header_length;

                // If ret is negative, the loop is jumped ! 
                for (i = 0; i < ret; i++) {
                        // shift reg hi_byte to temp OR with lo_byte 
                        tab_rq_registers[i] = (response[offset + 3 + (i << 1)] << 8) | 
                                response[offset + 4 + (i << 1)];
                                printf("%d -- %d", tab_rq_registers[i],i);     
                }
     //   }
   
   /*
                                        for (int i=0; i<nb; i++) {
                                                if (tab_rq_registers[i] != tab_rp_registers[i]) {
                                                        printf("ERROR read_holding_registers\n");
                                                        printf("Slave = %d, address = %d, value %d (0x%X) != %d (0x%X)\n",
                                                               SLAVE, addr,
                                                               tab_rq_registers[i], tab_rq_registers[i],
                                                               tab_rp_registers[i], tab_rp_registers[i]);
                                                        nb_fail++;
                                                }
                                        }
    */
    
}

void handleInterrupt2() {

while(serial.readable()) {
         printf("<%.2X>", serial.getc());
}

}

void modbus_test() {


     int ret;
        int nb_fail;
        int nb_loop;
        int addr;

         modbus_init_rtu(&mb_param, "/dev/ttyS0", 19200, "none", 8, 1);

        //modbus_set_debug(&mb_param, TRUE);
        if (modbus_connect(&mb_param) == -1) {
                printf("ERROR Connection failed\n");
                exit(1);
        }

        nb = ADDRESS_END - ADDRESS_START;

/*
        tab_rq_status = (uint8_t *) malloc(nb * sizeof(uint8_t));
        memset(tab_rq_status, 0, nb * sizeof(uint8_t));

        tab_rp_status = (uint8_t *) malloc(nb * sizeof(uint8_t));
        memset(tab_rp_status, 0, nb * sizeof(uint8_t));

        tab_rq_registers = (uint16_t *) malloc(nb * sizeof(uint16_t));
        memset(tab_rq_registers, 0, nb * sizeof(uint16_t));

        tab_rp_registers = (uint16_t *) malloc(nb * sizeof(uint16_t));
        memset(tab_rp_registers, 0, nb * sizeof(uint16_t));
*/
        serial.attach( handleInterrupt2);

        nb_loop = nb_fail = 0;
        while (nb_loop++ < LOOP) { 
                for (addr = ADDRESS_START; addr <= ADDRESS_END; addr++) {
                        int i;

                        for (i=0; i<nb; i++) {
                                tab_rq_registers[i] = (uint16_t) 44097+i;;
                                tab_rq_status[i] = tab_rq_registers[i] % 2;
                        }
                        nb = ADDRESS_END - addr;
/*
                        ret = preset_multiple_registers(&mb_param, SLAVE,
                                                        addr, nb, tab_rq_registers);
                        if (ret != nb) {
                                printf("ERROR preset_multiple_registers (%d)\n", ret);
                                printf("Slave = %d, address = %d, nb = %d\n",
                                               SLAVE, addr, nb);
                                nb_fail++;
                        } else {
                        */
                      /*
                                ret = read_holding_registers(&mb_param, SLAVE,
                                                             addr, nb, tab_rp_registers);
                                                             
                                                             
                                                               printf("HERER");
  */
  
          int ret;
        int query_length;
   

         query_length = build_query_basis_rtu(SLAVE, FC_READ_HOLDING_REGISTERS, addr, nb, query);
        //  query_length = build_query_basis(&mb_param, SLAVE, FC_READ_HOLDING_REGISTERS, addr, nb, query);

        ret = modbus_send(&mb_param, query, query_length);
                               
                        //}

                }
                        
                printf("Test: ");
                if (nb_fail)
                        printf("%d FAILS\n", nb_fail);
                else
                        printf("SUCCESS\n");
        }
      //  handleInterrupt();
/*
        free(tab_rq_status);
        free(tab_rp_status);                                           
        free(tab_rq_registers);
        free(tab_rp_registers);

        modbus_close(&mb_param);
 */       
}


int main() {
     myled = 1;
    console_port.baud(230400);
    serial.baud(57600);
    
  printf("Starting\n");

modbus_test();

    while(1) {
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
    }
}
