#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
#include "NTPClient.h"

#define RSS1M "CQ Interface>"
#define RSS1  "http://www.kumikomi.net/interface/atom.xml"
#define RSS2M "Sports Topic>"
#define RSS2  "http://news.goo.ne.jp/news/rss/topics/sports/index.rdf"
#define RSS3M "Make:Japan  >"
#define RSS3  "http://jp.makezine.com/blog/index.xml"
#define RSS4M "Weather NEWS>"
#define RSS4  "http://feeds.feedburner.jp/hitokuchi_4410"

Ticker rss_img;  // For RSS animation

DigitalIn  sw1(p17);
DigitalIn  sw2(p19);
DigitalIn  sw3(p20);
DigitalIn  sw4(p21);

int img = 26;  // animate img 26-29
int rss_no = 0;

Serial pc(USBTX, USBRX); // tx, rx
Serial lcd(p9, p10); // tx, rx

EthernetNetIf eth; 
HTTPClient http;
NTPClient ntp;

LocalFileSystem local("local"); 
HTTPResult result;
bool completed = false;

//* HTTP request callback ******************************************
void request_callback(HTTPResult r)
{
  result = r;
  completed = true;
}

//* animate RSS icon ***********************************************
void animate ()
{
    img++;
    if (img > 29) img = 26;
    lcd.printf("\x1b@%d;0;30;64I",img);
}

//* Display menu ****************************************************
void menu ()
{
    lcd.printf("\x1b@20;0I"); // Display Openning
    lcd.printf("\x1b[1;24H");   // 
    lcd.printf(RSS1M);   //
    lcd.printf("\x1b[5;24H");   // 
    lcd.printf(RSS2M);   //
    lcd.printf("\x1b[9;24H");   // 
    lcd.printf(RSS3M);   //
    lcd.printf("\x1b[13;24H");   // 
    lcd.printf(RSS4M);   //

}

//* Blink selected Item *********************************************
void select(int rss)
{
    for (int i=0;i<=3;i++)
    {
    lcd.printf("\x1b@25;0;180;%dI", ((rss-1)*64)+14);
    wait_ms(100);
    lcd.printf("\x1b@0;0;133;20;180;%d;0z", ((rss-1)*64)+14);
    wait_ms(50);
    }
        lcd.printf("\x1b@25;0;180;%dI", ((rss-1)*64)+14);
}

//****************************************************************************
//* M A I N
//****************************************************************************
int main() {

  int color = 0;
  int flag = 0;
  int count = 0;
  char c;
  char buffer[100];
  char BigBuf[512 + 1] = {0};

  // Init SW
  sw1.mode(PullUp);
  sw2.mode(PullUp);
  sw3.mode(PullUp);
  sw4.mode(PullUp);
  
  // Set lcd baudrate
  lcd.printf("\x1b@14Z"); // 57600bps
  lcd.baud(57600);

  lcd.printf("\x1b@80Z");       // Set Curser off
  lcd.printf("\x1b@0Z");        // clear all
  lcd.printf("\x1b@30Z");       // set buffer 0
  lcd.printf("\x1b[1;23;m");    // bold;white

  // Display gend Get menu ********************************
  menu();
  while ( rss_no == 0)
  {
    if (sw1 == 0 ) {rss_no = 1; select(1);}
    if (sw2 == 0 ) {rss_no = 2; select(2);}
    if (sw3 == 0 ) {rss_no = 3; select(3);}
    if (sw4 == 0 ) {rss_no = 4; select(4);}
  }

 
  rss_img.attach(&animate, 0.3); // the address of the function to be attached (flip) and the interval (2 seconds)
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    lcd.printf("Error %d in setup.\n\r", ethErr);
    return -1;
  }
  
  rss_img.detach();

  lcd.printf("\x1b[1;19;4;m"); //Set char to Blue
  lcd.printf("\x1b@21;0I"); // Dsiaplay backGround
  lcd.printf("\x1b[*");     // Claer all char and set curser to HP
  
  // Set UTF8
  lcd.printf("\x1b@21Z"); // Not CR/LF
  lcd.printf("\x1b[4;0H"); // Set Cuser to LINE 4
  lcd.printf("\x1b@3Z"); // Set Char code to UTF-8
  
  HTTPStream stream;

  completed=false;

  stream.readNext((byte*)BigBuf, 512); //Point to buffer for the first read
    
  if (rss_no == 1)
  {
//        lcd.printf("%s ...\n\r", RSS1);
    HTTPResult r = http.get(RSS1, &stream, request_callback);
  }
  if (rss_no == 2)
  {
//        lcd.printf("%s ...\n\r", RSS2);
    HTTPResult r = http.get(RSS2, &stream, request_callback);
  }
  if (rss_no == 3)
  {
//        lcd.printf("%s ...\n\r", RSS3);
    HTTPResult r = http.get(RSS3, &stream, request_callback);
  }
  if (rss_no == 4)
  {
//        lcd.printf("%s ...\n\r", RSS4);
    HTTPResult r = http.get(RSS4, &stream, request_callback);
  }
  rss_no = 0;
      
  FILE *fp = fopen("/local/out.txt", "w");  // Open "out.txt" on the local file system for writing
  while(!completed)
  {
    Net::poll(); //Polls the Networking stack
    if(stream.readable())
    {
      BigBuf[stream.readLen()] = 0; //Transform this buffer in a zero-terminated char* string
      fprintf(fp,BigBuf);
      //Note: some servers do not like if you throttle them too much, so printf'ing during a request is generally bad practice
      stream.readNext((byte*)BigBuf, 512); //Buffer has been read, now we can put more data in it
    }
  }
  fclose(fp); 
      
  fp = fopen( "/local/out.txt", "r");
         
  if (fp==NULL) printf ("Error opening file");
  else
  {
    do
    {
       c = fgetc (fp);
       if (c == '<')
       {
         c = fgetc(fp);
         if(c == 't')
         {
           c = fgetc(fp);
           if(c == 'i')
           {
             c = fgetc(fp);
             if(c == 't')
             {
               c = fgetc(fp);
               if( c == 'l')
               {
                 c = fgetc(fp);
                 if( c == 'e')
                 {
                   c = fgetc(fp);
                   if(c == '>')
                   {
                     count++;
                     if((count >=1) && (count <=10))
                     {
                     if(count == 11) break;
                     int i = 0;
                     c = fgetc(fp);
                     while(c != '<')
                     {
                         buffer[i] = c;
                         i++;
                         c = fgetc(fp);
                     }
                     buffer[i] = '\0';
                     lcd.printf("%s\n\r",buffer);
                     if (color == 0)
                     { lcd.printf("\x1b[29;23;24m"); //Set char to BLUE
                       color = 1;
                     } else {
                       lcd.printf("\x1b[29;18;24m"); //Set char to RED
                      color = 0;
                     }
                            
                    }
                  }
                }
              }
            }
          }
        }
      }
    }
    while (count <= 11);
    fclose (fp);
  } // END OF else

} // END OF main
